/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNetworkedJob {
    @Test(expected=IOException.class)
    public void testNullStatus() throws Exception {
        JobProfile mockProf = (JobProfile)Mockito.mock(JobProfile.class);
        JobSubmissionProtocol mockClient = (JobSubmissionProtocol)Mockito.mock(JobSubmissionProtocol.class);
        new JobClient.NetworkedJob(null, mockProf, mockClient);
    }

    @Test(expected=IOException.class)
    public void testNullProfile() throws Exception {
        JobStatus mockStatus = (JobStatus)Mockito.mock(JobStatus.class);
        JobSubmissionProtocol mockClient = (JobSubmissionProtocol)Mockito.mock(JobSubmissionProtocol.class);
        new JobClient.NetworkedJob(mockStatus, null, mockClient);
    }

    @Test(expected=IOException.class)
    public void testNullClient() throws Exception {
        JobStatus mockStatus = (JobStatus)Mockito.mock(JobStatus.class);
        JobProfile mockProf = (JobProfile)Mockito.mock(JobProfile.class);
        new JobClient.NetworkedJob(mockStatus, mockProf, null);
    }

    @Test
    public void testBadUpdate() throws Exception {
        JobStatus mockStatus = (JobStatus)Mockito.mock(JobStatus.class);
        JobProfile mockProf = (JobProfile)Mockito.mock(JobProfile.class);
        JobSubmissionProtocol mockClient = (JobSubmissionProtocol)Mockito.mock(JobSubmissionProtocol.class);
        JobID id = new JobID("test", 0);
        JobClient.NetworkedJob rj = new JobClient.NetworkedJob(mockStatus, mockProf, mockClient);
        Mockito.when((Object)mockProf.getJobID()).thenReturn((Object)id);
        Mockito.when((Object)mockClient.getJobStatus(id)).thenReturn(null);
        boolean caught = false;
        try {
            rj.isSuccessful();
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"Expected updateStatus to throw an IOException bt it did not", (boolean)caught);
        ((JobProfile)Mockito.verify((Object)mockProf)).getJobID();
        ((JobSubmissionProtocol)Mockito.verify((Object)mockClient)).getJobStatus(id);
    }

    @Test
    public void testGetNullCounters() throws Exception {
        JobStatus mockStatus = (JobStatus)Mockito.mock(JobStatus.class);
        JobProfile mockProf = (JobProfile)Mockito.mock(JobProfile.class);
        JobSubmissionProtocol mockClient = (JobSubmissionProtocol)Mockito.mock(JobSubmissionProtocol.class);
        JobClient.NetworkedJob underTest = new JobClient.NetworkedJob(mockStatus, mockProf, mockClient);
        JobID id = new JobID("test", 0);
        Mockito.when((Object)mockProf.getJobID()).thenReturn((Object)id);
        Mockito.when((Object)mockClient.getJobCounters(id)).thenReturn(null);
        Assert.assertNull((Object)underTest.getCounters());
        ((JobSubmissionProtocol)Mockito.verify((Object)mockClient)).getJobCounters(id);
    }
}

