/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestRackAwareTaskPlacement
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2", "/r2"};
    private static final String[] hosts2 = new String[]{"host1.rack2.com", "host2.rack2.com"};
    private static final String[] hosts3 = new String[]{"host3.rack1.com"};
    private static final String[] hosts4 = new String[]{"host1.rack2.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");

    static void launchJobAndTestCounters(String jobName, MiniMRCluster mr, FileSystem fileSys, Path in, Path out, int numMaps, int otherLocalMaps, int dataLocalMaps, int rackLocalMaps) throws IOException {
        JobConf jobConf = mr.createJobConf();
        if (fileSys.exists(out)) {
            fileSys.delete(out, true);
        }
        RunningJob job = TestRackAwareTaskPlacement.launchJob(jobConf, in, out, numMaps, jobName);
        Counters counters = job.getCounters();
        TestRackAwareTaskPlacement.assertEquals((String)"Number of local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.OTHER_LOCAL_MAPS), (long)otherLocalMaps);
        TestRackAwareTaskPlacement.assertEquals((String)"Number of Data-local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.DATA_LOCAL_MAPS), (long)dataLocalMaps);
        TestRackAwareTaskPlacement.assertEquals((String)"Number of Rack-local maps", (long)counters.getCounter((Enum)JobInProgress.Counter.RACK_LOCAL_MAPS), (long)rackLocalMaps);
        mr.waitUntilIdle();
        mr.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskPlacement() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        String testName = "TestForRackAwareness";
        try {
            boolean taskTrackers = true;
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file1"), (short)1);
            dfs.startDataNodes(conf, 2, true, null, rack2, hosts2, null);
            dfs.waitActive();
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file2"), (short)3);
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file3"), (short)3);
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            mr = new MiniMRCluster(1, namenode, 1, rack2, hosts4);
            TestRackAwareTaskPlacement.launchJobAndTestCounters(testName, mr, fileSys, this.inDir, this.outputPath, 3, 0, 2, 0);
            mr.shutdown();
            mr = new MiniMRCluster(1, namenode, 1, rack1, hosts3);
            TestRackAwareTaskPlacement.launchJobAndTestCounters(testName, mr, fileSys, this.inDir, this.outputPath, 3, 0, 0, 3);
            mr.shutdown();
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static RunningJob launchJob(JobConf jobConf, Path inDir, Path outputPath, int numMaps, String jobName) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(IdentityMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(0);
        jobConf.setJar("build/test/testjar/testjob.jar");
        return JobClient.runJob((JobConf)jobConf);
    }
}

