/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestShuffleJobToken {
    private static HttpServer server;
    private static URL baseUrl;
    private static File dir;
    private static final String JOB_ID = "job_20091117075357176_0001";
    private static final String BAD_JOB_ID = "job_20091117075357176_0002";

    private URL getMapOutputURL(String host) throws MalformedURLException {
        StringBuffer url = new StringBuffer(host);
        url.append("mapOutput?");
        url.append("job=job_20091117075357176_0001&");
        url.append("reduce=0&");
        url.append("map=attempt");
        return new URL(url.toString());
    }

    @Before
    public void setUp() throws Exception {
        dir = new File(System.getProperty("build.webapps", "build/webapps") + "/test");
        System.out.println("dir=" + dir.getAbsolutePath());
        if (!dir.exists()) {
            Assert.assertTrue((boolean)dir.mkdirs());
        }
        server = new HttpServer("test", "0.0.0.0", 0, true);
        server.addServlet("shuffle", "/mapOutput", TaskTracker.MapOutputServlet.class);
        server.start();
        int port = server.getPort();
        baseUrl = new URL("http://localhost:" + port + "/");
    }

    @After
    public void tearDown() throws Exception {
        if (dir.exists()) {
            dir.delete();
        }
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void testInvalidJobToken() throws IOException, GeneralSecurityException {
        URL url = this.getMapOutputURL(baseUrl.toString());
        String enc_str = SecureShuffleUtils.buildMsgFrom((URL)url);
        URLConnection connectionGood = url.openConnection();
        TaskTracker tt = new TaskTracker();
        JobTokenSecretManager jtSecretManager = new JobTokenSecretManager();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(JOB_ID));
        Token jt = new Token((TokenIdentifier)identifier, (SecretManager)jtSecretManager);
        SecretKey tokenSecret = JobTokenSecretManager.createSecretKey((byte[])jt.getPassword());
        this.addJobToken(tt, JOB_ID, (Token<JobTokenIdentifier>)jt);
        server.setAttribute("task.tracker", (Object)tt);
        String urlHashGood = SecureShuffleUtils.generateHash((byte[])enc_str.getBytes(), (SecretKey)tokenSecret);
        JobTokenIdentifier badIdentifier = new JobTokenIdentifier(new Text(BAD_JOB_ID));
        Token badToken = new Token((TokenIdentifier)badIdentifier, (SecretManager)jtSecretManager);
        SecretKey badSecret = JobTokenSecretManager.createSecretKey((byte[])badToken.getPassword());
        String urlHashBad = SecureShuffleUtils.generateHash((byte[])enc_str.getBytes(), (SecretKey)badSecret);
        connectionGood.addRequestProperty("UrlHash", urlHashGood);
        try {
            connectionGood.getInputStream();
        }
        catch (IOException ie) {
            String msg = ie.getLocalizedMessage();
            if (msg.contains("Server returned HTTP response code: 401 for URL:")) {
                Assert.fail((String)("securtity failure with valid urlHash:" + ie));
            }
            System.out.println("valid urlhash passed validation");
        }
        URLConnection connectionBad = url.openConnection();
        connectionBad.addRequestProperty("UrlHash", urlHashBad);
        try {
            connectionBad.getInputStream();
            Assert.fail((String)"Connection should've failed because of invalid urlHash");
        }
        catch (IOException ie) {
            String msg = ie.getLocalizedMessage();
            if (!msg.contains("Server returned HTTP response code: 401 for URL:")) {
                Assert.fail((String)("connection failed with other then validation error:" + ie));
            }
            System.out.println("validation worked, failed with:" + ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJobToken(TaskTracker tt, String jobIdStr, Token<JobTokenIdentifier> token) {
        JobID jobId = JobID.forName((String)jobIdStr);
        TaskTracker.RunningJob rJob = new TaskTracker.RunningJob(jobId);
        Map map = tt.runningJobs;
        synchronized (map) {
            tt.runningJobs.put(jobId, rJob);
        }
        tt.getJobTokenSecretManager().addTokenForJob(jobIdStr, token);
    }
}

