/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.filter.GlobFilter;
import org.apache.hadoop.metrics2.filter.RegexFilter;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestPatternFilter {
    @Test
    public void emptyConfigShouldAccept() {
        SubsetConfiguration empty = new ConfigBuilder().subset("");
        TestPatternFilter.shouldAccept(empty, "anything");
        TestPatternFilter.shouldAccept(empty, Arrays.asList(new MetricsTag("key", "desc", "value")));
    }

    @Test
    public void includeOnlyShouldOnlyIncludeMatched() {
        SubsetConfiguration wl = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(wl, "foo");
        TestPatternFilter.shouldAccept(wl, Arrays.asList(new MetricsTag("bar", "", ""), new MetricsTag("foo", "", "f")));
        TestPatternFilter.shouldReject(wl, "bar");
        TestPatternFilter.shouldReject(wl, Arrays.asList(new MetricsTag("bar", "", "")));
        TestPatternFilter.shouldReject(wl, Arrays.asList(new MetricsTag("foo", "", "boo")));
    }

    @Test
    public void excludeOnlyShouldOnlyExcludeMatched() {
        SubsetConfiguration bl = new ConfigBuilder().add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(bl, "bar");
        TestPatternFilter.shouldAccept(bl, Arrays.asList(new MetricsTag("bar", "", "")));
        TestPatternFilter.shouldReject(bl, "foo");
        TestPatternFilter.shouldReject(bl, Arrays.asList(new MetricsTag("bar", "", ""), new MetricsTag("foo", "", "f")));
    }

    @Test
    public void shouldAcceptUnmatchedWhenBothAreConfigured() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "bar").add("p.exclude.tags", "bar:b").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(new MetricsTag("foo", "", "f")));
        TestPatternFilter.shouldReject(c, "bar");
        TestPatternFilter.shouldReject(c, Arrays.asList(new MetricsTag("bar", "", "b")));
        TestPatternFilter.shouldAccept(c, "foobar");
        TestPatternFilter.shouldAccept(c, Arrays.asList(new MetricsTag("foobar", "", "")));
    }

    @Test
    public void includeShouldOverrideExclude() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(new MetricsTag("foo", "", "f")));
    }

    static void shouldAccept(SubsetConfiguration conf, String s) {
        Assert.assertTrue((String)("accepts " + s), (boolean)TestPatternFilter.newGlobFilter(conf).accepts(s));
        Assert.assertTrue((String)("accepts " + s), (boolean)TestPatternFilter.newRegexFilter(conf).accepts(s));
    }

    static void shouldAccept(SubsetConfiguration conf, List<MetricsTag> tags) {
        Assert.assertTrue((String)("accepts " + tags), (boolean)TestPatternFilter.newGlobFilter(conf).accepts(tags));
        Assert.assertTrue((String)("accepts " + tags), (boolean)TestPatternFilter.newRegexFilter(conf).accepts(tags));
    }

    static void shouldReject(SubsetConfiguration conf, String s) {
        Assert.assertTrue((String)("rejects " + s), (!TestPatternFilter.newGlobFilter(conf).accepts(s) ? 1 : 0) != 0);
        Assert.assertTrue((String)("rejects " + s), (!TestPatternFilter.newRegexFilter(conf).accepts(s) ? 1 : 0) != 0);
    }

    static void shouldReject(SubsetConfiguration conf, List<MetricsTag> tags) {
        Assert.assertTrue((String)("rejects " + tags), (!TestPatternFilter.newGlobFilter(conf).accepts(tags) ? 1 : 0) != 0);
        Assert.assertTrue((String)("rejects " + tags), (!TestPatternFilter.newRegexFilter(conf).accepts(tags) ? 1 : 0) != 0);
    }

    public static GlobFilter newGlobFilter(SubsetConfiguration conf) {
        GlobFilter f = new GlobFilter();
        f.init(conf);
        return f;
    }

    public static RegexFilter newRegexFilter(SubsetConfiguration conf) {
        RegexFilter f = new RegexFilter();
        f.init(conf);
        return f;
    }
}

