/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;

public class TestAuthenticationToken
extends TestCase {
    public void testAnonymous() {
        TestAuthenticationToken.assertNotNull((Object)AuthenticationToken.ANONYMOUS);
        TestAuthenticationToken.assertEquals(null, (String)AuthenticationToken.ANONYMOUS.getUserName());
        TestAuthenticationToken.assertEquals(null, (String)AuthenticationToken.ANONYMOUS.getName());
        TestAuthenticationToken.assertEquals(null, (String)AuthenticationToken.ANONYMOUS.getType());
        TestAuthenticationToken.assertEquals((long)-1L, (long)AuthenticationToken.ANONYMOUS.getExpires());
        TestAuthenticationToken.assertFalse((boolean)AuthenticationToken.ANONYMOUS.isExpired());
    }

    public void testConstructor() throws Exception {
        try {
            new AuthenticationToken(null, "p", "t");
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        try {
            new AuthenticationToken("", "p", "t");
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        try {
            new AuthenticationToken("u", null, "t");
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        try {
            new AuthenticationToken("u", "", "t");
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        try {
            new AuthenticationToken("u", "p", null);
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        try {
            new AuthenticationToken("u", "p", "");
            TestAuthenticationToken.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestAuthenticationToken.fail();
        }
        new AuthenticationToken("u", "p", "t");
    }

    public void testGetters() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        TestAuthenticationToken.assertEquals((String)"u", (String)token.getUserName());
        TestAuthenticationToken.assertEquals((String)"p", (String)token.getName());
        TestAuthenticationToken.assertEquals((String)"t", (String)token.getType());
        TestAuthenticationToken.assertEquals((long)expires, (long)token.getExpires());
        TestAuthenticationToken.assertFalse((boolean)token.isExpired());
        Thread.sleep(51L);
        TestAuthenticationToken.assertTrue((boolean)token.isExpired());
    }

    public void testToStringAndParse() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        token = AuthenticationToken.parse((String)str);
        TestAuthenticationToken.assertEquals((String)"p", (String)token.getName());
        TestAuthenticationToken.assertEquals((String)"t", (String)token.getType());
        TestAuthenticationToken.assertEquals((long)expires, (long)token.getExpires());
        TestAuthenticationToken.assertFalse((boolean)token.isExpired());
        Thread.sleep(51L);
        TestAuthenticationToken.assertTrue((boolean)token.isExpired());
    }

    public void testParseInvalid() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        str = str.substring(0, str.indexOf("e="));
        try {
            AuthenticationToken.parse((String)str);
            TestAuthenticationToken.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestAuthenticationToken.fail();
        }
    }
}

