/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.InMemoryFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestLocalFileSystem;

public class TestChecksumFileSystem
extends TestCase {
    public void testgetChecksumLength() throws Exception {
        TestChecksumFileSystem.assertEquals((long)8L, (long)ChecksumFileSystem.getChecksumLength((long)0L, (int)512));
        TestChecksumFileSystem.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)1L, (int)512));
        TestChecksumFileSystem.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)512L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)513L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1023L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1024L, (int)512));
        TestChecksumFileSystem.assertEquals((long)408L, (long)ChecksumFileSystem.getChecksumLength((long)100L, (int)1));
        TestChecksumFileSystem.assertEquals((long)4000000000008L, (long)ChecksumFileSystem.getChecksumLength((long)10000000000000L, (int)10));
    }

    public void testDeletionOfCheckSum() throws Exception {
        Configuration conf = new Configuration();
        URI uri = URI.create("ramfs://mapoutput_tmp");
        InMemoryFileSystem inMemFs = (InMemoryFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Path testPath = new Path("/file_1");
        inMemFs.reserveSpaceWithCheckSum(testPath, 1024L);
        FSDataOutputStream fout = inMemFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        TestChecksumFileSystem.assertTrue((String)"checksum exists", (boolean)inMemFs.exists(inMemFs.getChecksumFile(testPath)));
        inMemFs.delete(testPath, true);
        TestChecksumFileSystem.assertTrue((String)"checksum deleted", (!inMemFs.exists(inMemFs.getChecksumFile(testPath)) ? 1 : 0) != 0);
        testPath = new Path("/tesdir/file_1");
        inMemFs.reserveSpaceWithCheckSum(testPath, 1024L);
        fout = inMemFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        testPath = new Path("/testdir/file_2");
        inMemFs.reserveSpaceWithCheckSum(testPath, 1024L);
        fout = inMemFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        inMemFs.delete(testPath, true);
        TestChecksumFileSystem.assertTrue((String)"nothing in the namespace", (inMemFs.listStatus(new Path("/")).length == 0 ? 1 : 0) != 0);
    }

    public void testVerifyChecksum() throws Exception {
        String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/work-dir/localfs");
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path testPath = new Path(TEST_ROOT_DIR, "testPath");
        Path testPath11 = new Path(TEST_ROOT_DIR, "testPath11");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        fout = localFs.create(testPath11);
        fout.write("testing you".getBytes());
        fout.close();
        localFs.delete(localFs.getChecksumFile(testPath), true);
        TestChecksumFileSystem.assertTrue((String)"checksum deleted", (!localFs.exists(localFs.getChecksumFile(testPath)) ? 1 : 0) != 0);
        FileUtil.copy((FileSystem)localFs, (Path)localFs.getChecksumFile(testPath11), (FileSystem)localFs, (Path)localFs.getChecksumFile(testPath), (boolean)false, (boolean)true, (Configuration)conf);
        TestChecksumFileSystem.assertTrue((String)"checksum exists", (boolean)localFs.exists(localFs.getChecksumFile(testPath)));
        boolean errorRead = false;
        try {
            TestLocalFileSystem.readFile((FileSystem)localFs, testPath);
        }
        catch (ChecksumException ie) {
            errorRead = true;
        }
        TestChecksumFileSystem.assertTrue((String)"error reading", (boolean)errorRead);
        localFs.setVerifyChecksum(false);
        String str = TestLocalFileSystem.readFile((FileSystem)localFs, testPath);
        TestChecksumFileSystem.assertTrue((String)"read", (boolean)"testing".equals(str));
    }
}

