/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.protocol.BlockMetaDataInfo;

public class TestFileAppend3
extends TestCase {
    static final long BLOCK_SIZE = 65536L;
    static final short REPLICATION = 3;
    static final int DATANODE_NUM = 5;
    private static Configuration conf;
    private static int buffersize;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    public static Test suite() {
        return new TestSetup((Test)new TestSuite(TestFileAppend3.class)){

            protected void setUp() throws Exception {
                AppendTestUtil.LOG.info((Object)"setUp()");
                conf = new Configuration();
                conf.setInt("io.bytes.per.checksum", 512);
                conf.setBoolean("dfs.support.append", true);
                buffersize = conf.getInt("io.file.buffer.size", 4096);
                cluster = new MiniDFSCluster(conf, 5, true, null);
                fs = (DistributedFileSystem)cluster.getFileSystem();
            }

            protected void tearDown() throws Exception {
                AppendTestUtil.LOG.info((Object)"tearDown()");
                if (fs != null) {
                    fs.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
        };
    }

    public void testTC1() throws Exception {
        Path p = new Path("/TC1/foo");
        System.out.println("p=" + p);
        int len1 = 65536;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 65536);
        out.close();
        int len2 = 32768;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 65536, 32768);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
    }

    public void testTC2() throws Exception {
        Path p = new Path("/TC2/foo");
        System.out.println("p=" + p);
        int len1 = 98304;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 98304);
        out.close();
        int len2 = 16384;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 98304, 16384);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 114688L);
    }

    public void testTC5() throws Exception {
        Path p = new Path("/TC5/foo");
        System.out.println("p=" + p);
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 32768);
        out.close();
        out = fs.append(p);
        try {
            AppendTestUtil.createHdfsWithDifferentUsername(conf).append(p);
            TestFileAppend3.fail((String)"This should fail.");
        }
        catch (IOException ioe) {
            AppendTestUtil.LOG.info((Object)"GOOD: got an exception", (Throwable)ioe);
        }
        out.close();
    }

    public void testTC7() throws Exception {
        int repl = 2;
        Path p = new Path("/TC7/foo");
        System.out.println("p=" + p);
        int len1 = 32768;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)2, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 32768);
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fs, p, (short)2);
        LocatedBlocks locatedblocks = TestFileAppend3.fs.dfs.namenode.getBlockLocations(p.toString(), 0L, 32768L);
        TestFileAppend3.assertEquals((int)1, (int)locatedblocks.locatedBlockCount());
        LocatedBlock lb = locatedblocks.get(0);
        Block blk = lb.getBlock();
        TestFileAppend3.assertEquals((long)32768L, (long)lb.getBlockSize());
        DatanodeInfo[] datanodeinfos = lb.getLocations();
        TestFileAppend3.assertEquals((int)2, (int)datanodeinfos.length);
        DataNode dn = cluster.getDataNode(datanodeinfos[0].getIpcPort());
        FSDataset data = (FSDataset)dn.getFSDataset();
        RandomAccessFile raf = new RandomAccessFile(data.getBlockFile(blk), "rw");
        AppendTestUtil.LOG.info((Object)("dn=" + dn + ", blk=" + blk + " (length=" + blk.getNumBytes() + ")"));
        TestFileAppend3.assertEquals((long)32768L, (long)raf.length());
        raf.setLength(0L);
        raf.close();
        int len2 = 65536;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 32768, 65536);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
    }

    public void testTC11() throws Exception {
        Path p = new Path("/TC11/foo");
        System.out.println("p=" + p);
        int len1 = 65536;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 65536);
        out.close();
        out = fs.append(p);
        int len2 = 32768;
        AppendTestUtil.write((OutputStream)out, 65536, 32768);
        Path pnew = new Path(p + ".new");
        TestFileAppend3.assertTrue((boolean)fs.rename(p, pnew));
        try {
            out.close();
            TestFileAppend3.fail((String)"close() should throw an exception");
        }
        catch (Exception e) {
            AppendTestUtil.LOG.info((Object)"GOOD!", (Throwable)e);
        }
        cluster.setLeasePeriod(1000L, 1000L);
        AppendTestUtil.sleep(5000L);
        long len = fs.getFileStatus(pnew).getLen();
        LocatedBlocks locatedblocks = TestFileAppend3.fs.dfs.namenode.getBlockLocations(pnew.toString(), 0L, len);
        int numblock = locatedblocks.locatedBlockCount();
        for (int i = 0; i < numblock; ++i) {
            LocatedBlock lb = locatedblocks.get(i);
            Block blk = lb.getBlock();
            long size = lb.getBlockSize();
            if (i < numblock - 1) {
                TestFileAppend3.assertEquals((long)65536L, (long)size);
            }
            for (DatanodeInfo datanodeinfo : lb.getLocations()) {
                DataNode dn = cluster.getDataNode(datanodeinfo.getIpcPort());
                BlockMetaDataInfo metainfo = dn.getBlockMetaDataInfo(blk);
                TestFileAppend3.assertEquals((long)size, (long)metainfo.getNumBytes());
            }
        }
    }

    public void testTC12() throws Exception {
        Path p = new Path("/TC12/foo");
        System.out.println("p=" + p);
        int len1 = 25687;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 25687);
        out.close();
        int len2 = 5877;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 25687, 5877);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 31564L);
    }
}

