/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;

public class TestHDFSServerPorts
extends TestCase {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    Configuration config;
    File hdfsDir;

    public NameNode startNameNode() throws IOException {
        return this.startNameNode(false);
    }

    public NameNode startNameNode(boolean withService) throws IOException {
        String dataDir = System.getProperty("test.build.data");
        this.hdfsDir = new File(dataDir, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        this.config = new Configuration();
        this.config.set("dfs.name.dir", new File(this.hdfsDir, "name1").getPath());
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        if (withService) {
            NameNode.setServiceAddress((Configuration)this.config, (String)"localhost:0");
        }
        this.config.set("dfs.http.address", "0.0.0.0:0");
        NameNode.format((Configuration)this.config);
        String[] args = new String[]{};
        return NameNode.createNameNode((String[])args, (Configuration)this.config);
    }

    public DataNode startDataNode(int index, Configuration config) throws IOException {
        String dataDir = System.getProperty("test.build.data");
        File dataNodeDir = new File(dataDir, "data-" + index);
        config.set("dfs.data.dir", dataNodeDir.getPath());
        String[] args = new String[]{};
        return DataNode.createDataNode((String[])args, (Configuration)config);
    }

    public void stopDataNode(DataNode dn) {
        if (dn != null) {
            dn.shutdown();
        }
    }

    public void stopNameNode(NameNode nn) {
        if (nn != null) {
            nn.stop();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    private boolean canStartNameNode(Configuration conf) throws IOException {
        NameNode nn2 = null;
        try {
            nn2 = NameNode.createNameNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                return false;
            }
            throw e;
        }
        this.stopNameNode(nn2);
        return true;
    }

    private boolean canStartDataNode(Configuration conf) throws IOException {
        DataNode dn = null;
        try {
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                return false;
            }
            throw e;
        }
        dn.shutdown();
        return true;
    }

    private boolean canStartSecondaryNode(Configuration conf) throws IOException {
        SecondaryNameNode sn = null;
        try {
            sn = new SecondaryNameNode(conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                return false;
            }
            throw e;
        }
        sn.shutdown();
        return true;
    }

    public void testNameNodePorts() throws Exception {
        this.runTestNameNodePorts(false);
        this.runTestNameNodePorts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestNameNodePorts(boolean withService) throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode(withService);
            Configuration conf2 = new Configuration(this.config);
            conf2.set("dfs.name.dir", new File(this.hdfsDir, "name2").getPath());
            NameNode.format((Configuration)conf2);
            boolean started = this.canStartNameNode(conf2);
            TestHDFSServerPorts.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)"hdfs://localhost:0");
            started = this.canStartNameNode(conf2);
            TestHDFSServerPorts.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)"hdfs://localhost:0");
            conf2.set("dfs.http.address", "0.0.0.0:0");
            started = this.canStartNameNode(conf2);
            if (withService) {
                TestHDFSServerPorts.assertFalse((String)"Should've failed on service port", (boolean)started);
                FileSystem.setDefaultUri((Configuration)conf2, (String)"hdfs://localhost:0");
                conf2.set("dfs.namenode.http-address", "0.0.0.0:0");
                conf2.set("dfs.namenode.servicerpc-address", "localhost:0");
                started = this.canStartNameNode(conf2);
            }
            TestHDFSServerPorts.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            Configuration conf2 = new Configuration(this.config);
            conf2.set("dfs.data.dir", new File(this.hdfsDir, "data").getPath());
            conf2.set("dfs.datanode.address", FileSystem.getDefaultUri((Configuration)this.config).getAuthority());
            conf2.set("dfs.datanode.http.address", "0.0.0.0:0");
            boolean started = this.canStartDataNode(conf2);
            TestHDFSServerPorts.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", "localhost:0");
            conf2.set("dfs.datanode.http.address", this.config.get("dfs.http.address"));
            started = this.canStartDataNode(conf2);
            TestHDFSServerPorts.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", "localhost:0");
            conf2.set("dfs.datanode.http.address", "0.0.0.0:0");
            conf2.set("dfs.datanode.ipc.address", "localhost:0");
            started = this.canStartDataNode(conf2);
            TestHDFSServerPorts.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSecondaryNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            Configuration conf2 = new Configuration(this.config);
            conf2.set("dfs.secondary.http.address", this.config.get("dfs.http.address"));
            SecondaryNameNode.LOG.info((Object)("= Starting 1 on: " + conf2.get("dfs.secondary.http.address")));
            boolean started = this.canStartSecondaryNode(conf2);
            TestHDFSServerPorts.assertFalse((boolean)started);
            conf2.set("dfs.secondary.http.address", "0.0.0.0:0");
            SecondaryNameNode.LOG.info((Object)("= Starting 2 on: " + conf2.get("dfs.secondary.http.address")));
            started = this.canStartSecondaryNode(conf2);
            TestHDFSServerPorts.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }
}

