/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;

public abstract class FSDatasetTestUtil {
    public static void truncateBlock(DataNode dn, Block block, long newLength) throws IOException {
        FSDataset ds = (FSDataset)dn.data;
        File blockFile = ds.findBlockFile(block.getBlockId());
        if (blockFile == null) {
            throw new IOException("Can't find block file for block " + block + " on DN " + dn);
        }
        File metaFile = FSDataset.findMetaFile((File)blockFile);
        FSDataset.truncateBlock((File)blockFile, (File)metaFile, (long)block.getNumBytes(), (long)newLength);
    }

    public static void truncateBlockFile(File blockFile, long newLength) throws IOException {
        File metaFile = FSDataset.findMetaFile((File)blockFile);
        FSDataset.truncateBlock((File)blockFile, (File)metaFile, (long)blockFile.length(), (long)newLength);
    }
}

