/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DatanodeBlockInfo;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockReportGeneration {
    private static final long BLKID = 12345L;
    private static final long GENSTAMP = 1000L;
    private static final long LEN = 65536L;
    private static final Block FAKE_BLK = new Block(12345L, 65536L, 1000L);
    static final File TEST_DIR = new File(System.getProperty("test.build.data") + File.pathSeparatorChar + "TestBlockReportGeneration");
    Map<Block, File> seenOnDisk = new HashMap<Block, File>();
    Map<Block, DatanodeBlockInfo> volumeMap = new HashMap<Block, DatanodeBlockInfo>();
    Map<Block, FSDataset.ActiveFile> ongoingCreates = new HashMap<Block, FSDataset.ActiveFile>();

    @Before
    public void cleanupTestDir() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
        Assert.assertTrue((boolean)TEST_DIR.mkdirs());
    }

    @Test
    public void testEmpty() {
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertTrue((boolean)this.seenOnDisk.isEmpty());
    }

    @Test
    public void testOnDiskButNotMemory() {
        this.fakeSeenByScan(FAKE_BLK);
        this.fakeBlockOnDisk(FAKE_BLK);
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    @Test
    public void testInMemoryButNotOnDisk() {
        this.fakeInVolumeMap(FAKE_BLK);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
        Assert.assertTrue((boolean)this.volumeMap.containsKey(FAKE_BLK));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    @Test
    public void testRemovedAfterScan() {
        this.fakeSeenByScan(FAKE_BLK);
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
        Assert.assertFalse((boolean)this.volumeMap.containsKey(FAKE_BLK));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    @Test
    public void testAddedAfterScan() {
        this.fakeInVolumeMap(FAKE_BLK);
        this.fakeBlockOnDisk(FAKE_BLK);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
        Assert.assertTrue((boolean)this.volumeMap.containsKey(FAKE_BLK));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    @Test
    public void testGenstampChangedAfterScan() {
        Block oldGenStamp = FAKE_BLK;
        Block newGenStamp = new Block(FAKE_BLK);
        newGenStamp.setGenerationStamp(1001L);
        this.fakeSeenByScan(oldGenStamp);
        this.fakeInVolumeMap(newGenStamp);
        this.fakeBlockOnDisk(newGenStamp);
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(oldGenStamp));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(oldGenStamp));
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(newGenStamp));
    }

    @Test
    public void testGetGenerationStampFromFile() {
        File[] fileList = new File[]{new File("blk_-1362850638739812068_5351.meta.foo"), new File("blk_-1362850638739812068_5351meta"), new File("."), new File(".."), new File("blk_-1362850638739812068"), new File("blk_-1362850638739812068_5351.meta"), new File("blk_1453973893701037484"), new File("blk_1453973893701037484_4804.meta")};
        Assert.assertEquals((long)4804L, (long)FSDataset.getGenerationStampFromFile((File[])fileList, (File)new File("blk_1453973893701037484")));
        Assert.assertEquals((long)0L, (long)FSDataset.getGenerationStampFromFile((File[])fileList, (File)new File("blk_145397389370103")));
        Assert.assertEquals((long)0L, (long)FSDataset.getGenerationStampFromFile((File[])fileList, (File)new File("blk_99999")));
        Assert.assertEquals((long)0L, (long)FSDataset.getGenerationStampFromFile((File[])fileList, (File)new File("blk_")));
    }

    @Test
    public void testFileBeingCreated() {
        this.fakeInVolumeMap(FAKE_BLK);
        this.fakeBlockOnDisk(FAKE_BLK);
        this.fakeBeingCreated(FAKE_BLK);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
        Assert.assertTrue((boolean)this.volumeMap.containsKey(FAKE_BLK));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    @Test
    public void testReopenedDuringScan() {
        this.fakeSeenByScan(FAKE_BLK);
        this.fakeInVolumeMap(FAKE_BLK);
        this.fakeBeingCreated(FAKE_BLK);
        Assert.assertTrue((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
        Assert.assertTrue((boolean)this.volumeMap.containsKey(FAKE_BLK));
        FSDataset.reconcileRoughBlockScan(this.seenOnDisk, this.volumeMap, this.ongoingCreates);
        Assert.assertFalse((boolean)this.seenOnDisk.containsKey(FAKE_BLK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAsyncReport() throws Exception {
        FSDataset mock = (FSDataset)Mockito.mock(FSDataset.class);
        FSDataset.AsyncBlockReport abr = new FSDataset.AsyncBlockReport(mock);
        abr.start();
        try {
            for (int i = 0; i < 3; ++i) {
                HashMap mockResult = new HashMap();
                ((FSDataset)Mockito.doReturn(mockResult).when((Object)mock)).roughBlockScan();
                Assert.assertFalse((boolean)abr.isReady());
                abr.request();
                while (!abr.isReady()) {
                    Thread.sleep(10L);
                }
                Assert.assertSame(mockResult, (Object)abr.getAndReset());
                Assert.assertFalse((boolean)abr.isReady());
            }
        }
        finally {
            abr.shutdown();
        }
    }

    private void fakeBeingCreated(Block b) {
        this.ongoingCreates.put(b, new FSDataset.ActiveFile(this.blockFile(b), new ArrayList()));
    }

    private void fakeInVolumeMap(Block b) {
        this.volumeMap.put(b, new DatanodeBlockInfo(null, this.blockFile(b)));
    }

    private void fakeBlockOnDisk(Block b) {
        File f = this.blockFile(b);
        try {
            f.createNewFile();
            FSDataset.getMetaFile((File)f, (Block)b).createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create: " + f);
        }
    }

    private void fakeSeenByScan(Block b) {
        this.seenOnDisk.put(b, this.blockFile(b));
    }

    private File blockFile(Block b) {
        return new File(TEST_DIR, b.getBlockName());
    }
}

