/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.TestByteRangeInputStream;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestOffsetUrlInputStream {
    @Test
    public void testRemoveOffset() throws IOException {
        String s = "http://test/Abc?Length=99";
        Assert.assertEquals((Object)s, (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
        s = "http://test/Abc";
        Assert.assertEquals((Object)s, (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
        s = "http://test/Abc?offset=10&Length=99";
        Assert.assertEquals((Object)"http://test/Abc?Length=99", (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
        s = "http://test/Abc?op=read&OFFset=10&Length=99";
        Assert.assertEquals((Object)"http://test/Abc?op=read&Length=99", (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
        s = "http://test/Abc?Length=99&offset=10";
        Assert.assertEquals((Object)"http://test/Abc?Length=99", (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
        s = "http://test/Abc?offset=10";
        Assert.assertEquals((Object)"http://test/Abc", (Object)WebHdfsFileSystem.removeOffsetParam((URL)new URL(s)).toString());
    }

    @Test
    public void testByteRange() throws Exception {
        WebHdfsFileSystem webhdfs;
        Configuration conf = new Configuration();
        String uri = "webhdfs://localhost:50070/";
        WebHdfsFileSystem webHdfsFileSystem = webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)new URI("webhdfs://localhost:50070/"), (Configuration)conf);
        webHdfsFileSystem.getClass();
        WebHdfsFileSystem.OffsetUrlOpener ospy = (WebHdfsFileSystem.OffsetUrlOpener)Mockito.spy((Object)new WebHdfsFileSystem.OffsetUrlOpener(webHdfsFileSystem, new URL("http://test/")));
        ((WebHdfsFileSystem.OffsetUrlOpener)Mockito.doReturn((Object)new TestByteRangeInputStream.MockHttpURLConnection(ospy.getURL())).when((Object)ospy)).openConnection();
        WebHdfsFileSystem webHdfsFileSystem2 = webhdfs;
        webHdfsFileSystem2.getClass();
        WebHdfsFileSystem.OffsetUrlOpener rspy = (WebHdfsFileSystem.OffsetUrlOpener)Mockito.spy((Object)new WebHdfsFileSystem.OffsetUrlOpener(webHdfsFileSystem2, (URL)null));
        ((WebHdfsFileSystem.OffsetUrlOpener)Mockito.doReturn((Object)new TestByteRangeInputStream.MockHttpURLConnection(rspy.getURL())).when((Object)rspy)).openConnection();
        WebHdfsFileSystem.OffsetUrlInputStream is = new WebHdfsFileSystem.OffsetUrlInputStream(ospy, rspy);
        Assert.assertEquals((String)"getPos wrong", (long)0L, (long)is.getPos());
        is.read();
        Assert.assertNull((String)"Initial call made incorrectly (Range Check)", (Object)ospy.openConnection().getRequestProperty("Range"));
        Assert.assertEquals((String)"getPos should be 1 after reading one byte", (long)1L, (long)is.getPos());
        is.read();
        Assert.assertEquals((String)"getPos should be 2 after reading two bytes", (long)2L, (long)is.getPos());
        rspy.setURL(new URL("http://resolvedurl/"));
        is.seek(100L);
        is.read();
        Assert.assertEquals((String)"getPos should be 101 after reading one byte", (long)101L, (long)is.getPos());
        ((WebHdfsFileSystem.OffsetUrlOpener)Mockito.verify((Object)rspy, (VerificationMode)Mockito.times((int)1))).openConnection();
        is.seek(101L);
        is.read();
        ((WebHdfsFileSystem.OffsetUrlOpener)Mockito.verify((Object)rspy, (VerificationMode)Mockito.times((int)1))).openConnection();
        is.seek(2500L);
        is.read();
        ((TestByteRangeInputStream.MockHttpURLConnection)rspy.openConnection()).setResponseCode(206);
        is.seek(0L);
        try {
            is.read();
            Assert.fail((String)"Exception should be thrown when 206 response is given but 200 is expected");
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info((Object)e.toString());
        }
    }
}

