/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;

public class TestSequenceFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSequenceFile.class);
    private static Configuration conf = new Configuration();

    public TestSequenceFile(String name) {
        super(name);
    }

    public void testZlibSequenceFile() throws Exception {
        LOG.info((Object)"Testing SequenceFile with DefaultCodec");
        this.compressedSeqFileTest((CompressionCodec)new DefaultCodec());
        LOG.info((Object)"Successfully tested SequenceFile with DefaultCodec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressedSeqFileTest(CompressionCodec codec) throws Exception {
        int count = 10240;
        int megabytes = 1;
        int factor = 5;
        Path file = new Path(System.getProperty("test.build.data", ".") + "/test.seq");
        Path recordCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.rc.seq");
        Path blockCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.bc.seq");
        int seed = new Random().nextInt();
        LOG.info((Object)("Seed = " + seed));
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        try {
            TestSequenceFile.writeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null);
            TestSequenceFile.readTest((FileSystem)fs, count, seed, file);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, false, file);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, file);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, true, file);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, file);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, false, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, file);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, true, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, file);
            TestSequenceFile.writeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, codec);
            TestSequenceFile.readTest((FileSystem)fs, count, seed, recordCompressedFile);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, false, recordCompressedFile);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, true, recordCompressedFile);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, false, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, true, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            TestSequenceFile.writeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, codec);
            TestSequenceFile.readTest((FileSystem)fs, count, seed, blockCompressedFile);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, false, blockCompressedFile);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            TestSequenceFile.sortTest((FileSystem)fs, count, megabytes, factor, true, blockCompressedFile);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, false, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            TestSequenceFile.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, true, factor, megabytes);
            TestSequenceFile.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
        }
        finally {
            fs.close();
        }
    }

    private static void writeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec) throws IOException {
        fs.delete(file, true);
        LOG.info((Object)("creating " + count + " records with " + compressionType + " compression"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    private static void readTest(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.debug((Object)("reading " + count + " records"));
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, conf);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        DataOutputBuffer rawKey = new DataOutputBuffer();
        SequenceFile.ValueBytes rawValue = reader.createValueBytes();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            try {
                if (i % 5 == 0) {
                    rawKey.reset();
                    reader.nextRaw(rawKey, rawValue);
                    continue;
                }
                if (i % 2 == 0) {
                    reader.next((Writable)k);
                    reader.getCurrentValue((Writable)v);
                } else {
                    reader.next((Writable)k, (Writable)v);
                }
                if (!k.equals(key)) {
                    throw new RuntimeException("wrong key at " + i);
                }
                if (v.equals(value)) continue;
                throw new RuntimeException("wrong value at " + i);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Problem on row " + i));
                LOG.info((Object)("Expected key = " + key));
                LOG.info((Object)("Expected len = " + key.getLength()));
                LOG.info((Object)("Actual key = " + k));
                LOG.info((Object)("Actual len = " + k.getLength()));
                LOG.info((Object)("Expected value = " + value));
                LOG.info((Object)("Expected len = " + value.getLength()));
                LOG.info((Object)("Actual value = " + v));
                LOG.info((Object)("Actual len = " + v.getLength()));
                LOG.info((Object)("Key equals: " + k.equals(key)));
                LOG.info((Object)("value equals: " + v.equals(value)));
                throw ioe;
            }
        }
        reader.close();
    }

    private static void sortTest(FileSystem fs, int count, int megabytes, int factor, boolean fast, Path file) throws IOException {
        fs.delete(new Path(file + ".sorted"), true);
        SequenceFile.Sorter sorter = TestSequenceFile.newSorter(fs, fast, megabytes, factor);
        LOG.debug((Object)("sorting " + count + " records"));
        sorter.sort(file, file.suffix(".sorted"));
        LOG.info((Object)("done sorting " + count + " debug"));
    }

    private static void checkSort(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.info((Object)("sorting " + count + " records in memory for debug"));
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        TreeMap<RandomDatum, RandomDatum> map = new TreeMap<RandomDatum, RandomDatum>();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            map.put(key, value);
        }
        LOG.debug((Object)("checking order of " + count + " records"));
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        Iterator iterator = map.entrySet().iterator();
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file.suffix(".sorted"), conf);
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = iterator.next();
            RandomDatum key = (RandomDatum)entry.getKey();
            RandomDatum value = (RandomDatum)entry.getValue();
            reader.next((Writable)k, (Writable)v);
            if (!k.equals(key)) {
                throw new RuntimeException("wrong key at " + i);
            }
            if (v.equals(value)) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        LOG.debug((Object)("sucessfully checked " + count + " records"));
    }

    private static void mergeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, boolean fast, int factor, int megabytes) throws IOException {
        int i;
        LOG.debug((Object)("creating " + factor + " files with " + count / factor + " records"));
        SequenceFile.Writer[] writers = new SequenceFile.Writer[factor];
        Path[] names = new Path[factor];
        Path[] sortedNames = new Path[factor];
        for (int i2 = 0; i2 < factor; ++i2) {
            names[i2] = file.suffix("." + i2);
            sortedNames[i2] = names[i2].suffix(".sorted");
            fs.delete(names[i2], true);
            fs.delete(sortedNames[i2], true);
            writers[i2] = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)names[i2], RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType);
        }
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writers[i % factor].append((Writable)key, (Writable)value);
        }
        for (i = 0; i < factor; ++i) {
            writers[i].close();
        }
        for (i = 0; i < factor; ++i) {
            LOG.debug((Object)("sorting file " + i + " with " + count / factor + " records"));
            TestSequenceFile.newSorter(fs, fast, megabytes, factor).sort(names[i], sortedNames[i]);
        }
        LOG.info((Object)("merging " + factor + " files with " + count / factor + " debug"));
        fs.delete(new Path(file + ".sorted"), true);
        TestSequenceFile.newSorter(fs, fast, megabytes, factor).merge(sortedNames, file.suffix(".sorted"));
    }

    private static SequenceFile.Sorter newSorter(FileSystem fs, boolean fast, int megabytes, int factor) {
        SequenceFile.Sorter sorter = fast ? new SequenceFile.Sorter(fs, (RawComparator)new RandomDatum.Comparator(), RandomDatum.class, RandomDatum.class, conf) : new SequenceFile.Sorter(fs, RandomDatum.class, RandomDatum.class, conf);
        sorter.setMemory(megabytes * 1024 * 1024);
        sorter.setFactor(factor);
        return sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceFileMetadata() throws Exception {
        LOG.info((Object)"Testing SequenceFile with metadata");
        int count = 10240;
        boolean megabytes = true;
        int factor = 5;
        DefaultCodec codec = new DefaultCodec();
        Path file = new Path(System.getProperty("test.build.data", ".") + "/test.seq.metadata");
        Path recordCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.rc.seq.metadata");
        Path blockCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.bc.seq.metadata");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        SequenceFile.Metadata theMetadata = new SequenceFile.Metadata();
        theMetadata.set(new Text("name_1"), new Text("value_1"));
        theMetadata.set(new Text("name_2"), new Text("value_2"));
        theMetadata.set(new Text("name_3"), new Text("value_3"));
        theMetadata.set(new Text("name_4"), new Text("value_4"));
        int seed = new Random().nextInt();
        try {
            TestSequenceFile.writeMetadataTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null, theMetadata);
            SequenceFile.Metadata aMetadata = TestSequenceFile.readMetadata((FileSystem)fs, file);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  1");
            }
            TestSequenceFile.writeMetadataTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, (CompressionCodec)codec, theMetadata);
            aMetadata = TestSequenceFile.readMetadata((FileSystem)fs, recordCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  2");
            }
            TestSequenceFile.writeMetadataTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec, theMetadata);
            aMetadata = TestSequenceFile.readMetadata((FileSystem)fs, blockCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  3");
            }
        }
        finally {
            fs.close();
        }
        LOG.info((Object)"Successfully tested SequenceFile with metadata");
    }

    private static SequenceFile.Metadata readMetadata(FileSystem fs, Path file) throws IOException {
        LOG.info((Object)("reading file: " + file.toString() + "\n"));
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, conf);
        SequenceFile.Metadata meta = reader.getMetadata();
        reader.close();
        return meta;
    }

    private static void writeMetadataTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec, SequenceFile.Metadata metadata) throws IOException {
        fs.delete(file, true);
        LOG.info((Object)("creating " + count + " records with metadata and with" + compressionType + " compression"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, null, (SequenceFile.Metadata)metadata);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    public void testClose() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path1 = new Path(System.getProperty("test.build.data", ".") + "/test1.seq");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path1, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file1-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file1-2"), (Writable)NullWritable.get());
        writer.close();
        Path path2 = new Path(System.getProperty("test.build.data", ".") + "/test2.seq");
        writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path2, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file2-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file2-2"), (Writable)NullWritable.get());
        writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        reader.close();
        reader.close();
        SequenceFile.Reader reader1 = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        Text text = new Text();
        reader1.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file1-1", (String)text.toString());
        SequenceFile.Reader reader2 = new SequenceFile.Reader((FileSystem)fs, path2, conf);
        reader2.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file2-1", (String)text.toString());
        reader1.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file1-2", (String)text.toString());
        reader2.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file2-2", (String)text.toString());
        TestSequenceFile.assertFalse((boolean)reader1.next((Writable)text));
        TestSequenceFile.assertFalse((boolean)reader2.next((Writable)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        int megabytes = 1;
        int factor = 10;
        boolean create = true;
        boolean rwonly = false;
        boolean check = false;
        boolean fast = false;
        boolean merge = false;
        String compressType = "NONE";
        String compressionCodec = "org.apache.hadoop.io.compress.DefaultCodec";
        Path file = null;
        int seed = new Random().nextInt();
        String usage = "Usage: SequenceFile [-count N] [-seed #] [-check] [-compressType <NONE|RECORD|BLOCK>] -codec <compressionCodec> [[-rwonly] | {[-megabytes M] [-factor F] [-nocreate] [-fast] [-merge]}]  file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        FileSystem fs = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-megabytes")) {
                    megabytes = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-factor")) {
                    factor = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    seed = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-rwonly")) {
                    rwonly = true;
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-check")) {
                    check = true;
                    continue;
                }
                if (args[i].equals("-fast")) {
                    fast = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    merge = true;
                    continue;
                }
                if (args[i].equals("-compressType")) {
                    compressType = args[++i];
                    continue;
                }
                if (args[i].equals("-codec")) {
                    compressionCodec = args[++i];
                    continue;
                }
                file = new Path(args[i]);
            }
            fs = file.getFileSystem(conf);
            LOG.info((Object)("count = " + count));
            LOG.info((Object)("megabytes = " + megabytes));
            LOG.info((Object)("factor = " + factor));
            LOG.info((Object)("create = " + create));
            LOG.info((Object)("seed = " + seed));
            LOG.info((Object)("rwonly = " + rwonly));
            LOG.info((Object)("check = " + check));
            LOG.info((Object)("fast = " + fast));
            LOG.info((Object)("merge = " + merge));
            LOG.info((Object)("compressType = " + compressType));
            LOG.info((Object)("compressionCodec = " + compressionCodec));
            LOG.info((Object)("file = " + file));
            if (rwonly && (!create || merge || fast)) {
                System.err.println(usage);
                System.exit(-1);
            }
            SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.valueOf((String)compressType);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(compressionCodec), (Configuration)conf);
            if (rwonly || create && !merge) {
                TestSequenceFile.writeTest(fs, count, seed, file, compressionType, codec);
                TestSequenceFile.readTest(fs, count, seed, file);
            }
            if (!rwonly) {
                if (merge) {
                    TestSequenceFile.mergeTest(fs, count, seed, file, compressionType, fast, factor, megabytes);
                } else {
                    TestSequenceFile.sortTest(fs, count, megabytes, factor, fast, file);
                }
            }
            if (check) {
                TestSequenceFile.checkSort(fs, count, seed, file);
            }
        }
        finally {
            fs.close();
        }
    }
}

