/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;

public class TestCodecFactory
extends TestCase {
    private static CompressionCodecFactory setClasses(Class[] classes) {
        Configuration conf = new Configuration();
        CompressionCodecFactory.setCodecClasses((Configuration)conf, Arrays.asList(classes));
        return new CompressionCodecFactory(conf);
    }

    private static void checkCodec(String msg, Class expected, CompressionCodec actual) {
        TestCodecFactory.assertEquals((String)(msg + " unexpected codec found"), (String)expected.getName(), (String)actual.getClass().getName());
    }

    public static void testFinding() {
        CompressionCodecFactory factory = new CompressionCodecFactory(new Configuration());
        CompressionCodec codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.assertEquals((String)"default factory foo codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.gz"));
        TestCodecFactory.checkCodec("default factory for .gz", GzipCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.checkCodec("default factory for .bz2", BZip2Codec.class, codec);
        factory = TestCodecFactory.setClasses(new Class[0]);
        codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.assertEquals((String)"empty codec bar codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.gz"));
        TestCodecFactory.assertEquals((String)"empty codec gz codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.assertEquals((String)"default factory for .bz2", null, (Object)codec);
        factory = TestCodecFactory.setClasses(new Class[]{BarCodec.class, FooCodec.class, FooBarCodec.class});
        codec = factory.getCodec(new Path("/tmp/.foo.bar.gz"));
        TestCodecFactory.assertEquals((String)"full factory gz codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.assertEquals((String)"default factory for .bz2", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.checkCodec("full factory bar codec", BarCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo/baz.foo.bar"));
        TestCodecFactory.checkCodec("full factory foo bar codec", FooBarCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.foo"));
        TestCodecFactory.checkCodec("full factory foo codec", FooCodec.class, codec);
    }

    private static class FooCodec
    extends BaseCodec {
        private FooCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return ".foo";
        }
    }

    private static class FooBarCodec
    extends BaseCodec {
        private FooBarCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return ".foo.bar";
        }
    }

    private static class BarCodec
    extends BaseCodec {
        private BarCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return "bar";
        }
    }

    private static class BaseCodec
    implements CompressionCodec {
        private Configuration conf;

        private BaseCodec() {
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return null;
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public String getDefaultExtension() {
            return ".base";
        }
    }
}

