/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.junit.Test;

public class TestDuplicateArchiveFileCachedURL
extends TestCase {
    private static String DUPLICATED_URL_CORE = "file://foo/myapp/map.zip";
    private static String UNDUPLICATED_URL_CORE = "file://foo/myapp/something-else.zip";
    int outputDirectoryIndex = 0;

    @Test
    public void testArchivesFilesJobSubmisisions() throws Exception {
        Symbolicness SYMLINK = Symbolicness.SYMLINK;
        Symbolicness NOLINK = Symbolicness.NOLINK;
        Erroneasness ERROR = Erroneasness.ERROR;
        Erroneasness NO_ERROR = Erroneasness.NO_ERROR;
        URI fileURI = new URI(DUPLICATED_URL_CORE);
        URI symlinkURI = new URI(DUPLICATED_URL_CORE + "#symlink");
        URI nonConflictingURI = new URI(UNDUPLICATED_URL_CORE);
        this.testSubmission(null, null, NOLINK, NO_ERROR);
        this.testSubmission(null, null, SYMLINK, NO_ERROR);
        this.testSubmission(fileURI, nonConflictingURI, NOLINK, NO_ERROR);
        this.testSubmission(fileURI, nonConflictingURI, SYMLINK, NO_ERROR);
        this.testSubmission(null, nonConflictingURI, NOLINK, NO_ERROR);
        this.testSubmission(null, nonConflictingURI, SYMLINK, NO_ERROR);
        this.testSubmission(fileURI, fileURI, NOLINK, ERROR);
        this.testSubmission(fileURI, symlinkURI, NOLINK, NO_ERROR);
        this.testSubmission(fileURI, symlinkURI, SYMLINK, ERROR);
    }

    private void testSubmission(URI archive, URI file, Symbolicness symbolicness, Erroneasness expectError) {
        JobConf conf = null;
        String testDescription = " archives = {" + (archive == null ? "" : archive.toString()) + "}, file = {" + (file == null ? "" : file.toString()) + "}, " + (Object)((Object)symbolicness);
        try {
            conf = new JobConf(TestDuplicateArchiveFileCachedURL.class);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)fs);
            Path inFile = new Path(testdir, "nullin/blah");
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inFile, NullWritable.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            Text t = new Text();
            t.set("AAAAAAAAAAAAAA");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("BBBBBBBBBBBBBB");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("CCCCCCCCCCCCCC");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("DDDDDDDDDDDDDD");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("EEEEEEEEEEEEEE");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("FFFFFFFFFFFFFF");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("GGGGGGGGGGGGGG");
            w.append((Writable)NullWritable.get(), (Writable)t);
            t.set("HHHHHHHHHHHHHH");
            w.append((Writable)NullWritable.get(), (Writable)t);
            w.close();
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(testdir, "nullout" + ++this.outputDirectoryIndex));
            conf.setMapperClass(NullMapper.class);
            conf.setReducerClass(IdentityReducer.class);
            conf.setOutputKeyClass(NullWritable.class);
            conf.setOutputValueClass(Text.class);
            conf.setInputFormat(SequenceFileInputFormat.class);
            conf.setOutputFormat(SequenceFileOutputFormat.class);
            conf.setNumReduceTasks(1);
            if (symbolicness == Symbolicness.SYMLINK) {
                DistributedCache.createSymlink((Configuration)conf);
            }
            if (archive != null) {
                System.out.println("adding archive: " + archive);
                DistributedCache.addCacheArchive((URI)archive, (Configuration)conf);
            }
            if (file != null) {
                DistributedCache.addCacheFile((URI)file, (Configuration)conf);
            }
        }
        catch (IOException e) {
            System.out.println("testSubmission -- got exception setting up a job.");
            e.printStackTrace();
        }
        try {
            JobClient.runJob((JobConf)conf);
            TestDuplicateArchiveFileCachedURL.assertTrue((String)("A test, " + testDescription + ", succeeded but should have failed."), (expectError == Erroneasness.NO_ERROR ? 1 : 0) != 0);
            System.out.println(testDescription + " succeeded, as we expected.");
        }
        catch (InvalidJobConfException e) {
            TestDuplicateArchiveFileCachedURL.assertTrue((String)("A test, " + testDescription + ", succeeded but should have failed."), (expectError == Erroneasness.ERROR ? 1 : 0) != 0);
            System.out.println(testDescription + " failed on duplicated cached files," + " as we expected.");
        }
        catch (FileNotFoundException e) {
            TestDuplicateArchiveFileCachedURL.assertEquals((String)(testDescription + "We shouldn't be unpacking files if there's a clash"), (Object)((Object)Erroneasness.NO_ERROR), (Object)((Object)expectError));
            System.out.println(testDescription + " got an expected " + "FileNotFoundException because we" + " don't provide cached files");
        }
        catch (IOException e) {
            e.printStackTrace();
            TestDuplicateArchiveFileCachedURL.assertTrue((String)("During a test, " + testDescription + ", runJob throws an IOException other" + "than an InvalidJobConfException."), (boolean)false);
        }
    }

    private static class NullMapper
    implements Mapper<NullWritable, Text, NullWritable, Text> {
        private NullMapper() {
        }

        public void map(NullWritable key, Text val, OutputCollector<NullWritable, Text> output, Reporter reporter) throws IOException {
            output.collect((Object)NullWritable.get(), (Object)val);
        }

        public void configure(JobConf conf) {
        }

        public void close() {
        }
    }

    private static enum Erroneasness {
        ERROR,
        NO_ERROR;

    }

    private static enum Symbolicness {
        SYMLINK,
        NOLINK;

    }
}

