/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;

public class TestJobHistoryParsing
extends TestCase {
    ArrayList<PrintWriter> historyWriter = new ArrayList();

    public void testHistoryParsing() throws IOException {
        Path historyDir = new Path(System.getProperty("test.build.data", "."), "history");
        JobConf conf = new JobConf();
        conf.set("hadoop.job.history.location", historyDir.toString());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new JobConf());
        JobHistory.init(null, (JobConf)conf, (String)"localhost", (long)1234L);
        Path historyLog = new Path(historyDir, "testlog");
        PrintWriter out = new PrintWriter((OutputStream)fs.create(historyLog));
        this.historyWriter.add(out);
        String value1 = "Value has equal=to, \"quotes\" and spaces in it";
        String value2 = "Value has \n new line \n and dot followed by new line .\n in it ";
        String value3 = "Value has characters: `1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"'ZXCVBNM<>?\t\b\n\f\"\n in it";
        String value4 = "Value ends with escape\\";
        String value5 = "Value ends with \\\" \\.\n";
        StringBuilder sb = new StringBuilder("Longer value with many escaped chars, which tends to overflow the stack of brittle regex parsers");
        for (int i = 0; i < 1000; ++i) {
            sb.append(",");
            sb.append("\\split.");
            sb.append(i);
        }
        String value6 = sb.toString();
        JobHistory.MetaInfoManager.logMetaInfo(this.historyWriter);
        JobHistory.log(this.historyWriter, (JobHistory.RecordTypes)JobHistory.RecordTypes.Job, (JobHistory.Keys[])new JobHistory.Keys[]{JobHistory.Keys.JOBTRACKERID, JobHistory.Keys.TRACKER_NAME, JobHistory.Keys.JOBNAME, JobHistory.Keys.JOBCONF, JobHistory.Keys.USER, JobHistory.Keys.SPLITS}, (String[])new String[]{value1, value2, value3, value4, value5, value6});
        out.close();
        this.historyWriter.remove(out);
        String jobId = "job_200809171136_0001";
        JobHistory.JobInfo job = new JobHistory.JobInfo(jobId);
        JobHistory.parseHistoryFromFS((String)historyLog.toString(), (JobHistory.Listener)new TestListener(job), (FileSystem)fs);
        TestJobHistoryParsing.assertEquals((String)value1, (String)job.get(JobHistory.Keys.JOBTRACKERID));
        TestJobHistoryParsing.assertEquals((String)value2, (String)job.get(JobHistory.Keys.TRACKER_NAME));
        TestJobHistoryParsing.assertEquals((String)value3, (String)job.get(JobHistory.Keys.JOBNAME));
        TestJobHistoryParsing.assertEquals((String)value4, (String)job.get(JobHistory.Keys.JOBCONF));
        TestJobHistoryParsing.assertEquals((String)value5, (String)job.get(JobHistory.Keys.USER));
        TestJobHistoryParsing.assertEquals((String)value6, (String)job.get(JobHistory.Keys.SPLITS));
    }

    static class TestListener
    implements JobHistory.Listener {
        JobHistory.JobInfo job;

        TestListener(JobHistory.JobInfo job) {
            this.job = job;
        }

        public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
            if (recType == JobHistory.RecordTypes.Job) {
                this.job.handle(values);
            }
        }
    }
}

