/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestMiniMRTaskTempDir
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMiniMRTaskTempDir.class.getName());
    private MiniMRCluster mr;
    private MiniDFSCluster dfs;
    private FileSystem fileSys;

    public void launchTest(JobConf conf, Path inDir, Path outDir, String input) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("testmap");
        conf.setMapperClass(MapClass.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
        conf.set("mapred.child.tmp", "../temp");
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
        conf.set("mapred.child.tmp", "/tmp");
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
    }

    public void testTaskTempDir() {
        try {
            this.dfs = new MiniDFSCluster(new Configuration(), 1, true, null);
            this.fileSys = this.dfs.getFileSystem();
            this.mr = new MiniMRCluster(2, this.fileSys.getUri().toString(), 1);
            JobConf conf = this.mr.createJobConf();
            Path inDir = new Path("testing/wc/input");
            Path outDir = new Path("testing/wc/output");
            String input = "The input";
            this.launchTest(conf, inDir, outDir, input);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMiniMRTaskTempDir.fail((String)"Exception in testing temp dir");
            try {
                if (this.fileSys != null) {
                    this.fileSys.close();
                }
                if (this.dfs != null) {
                    this.dfs.shutdown();
                }
                if (this.mr != null) {
                    this.mr.shutdown();
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)"IO exception in closing file system)");
                ioe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        TestMiniMRTaskTempDir test = new TestMiniMRTaskTempDir();
        test.testTaskTempDir();
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        Path tmpDir;
        FileSystem localFs;

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String tmp = null;
            if (this.localFs.exists(this.tmpDir)) {
                tmp = this.tmpDir.makeQualified(this.localFs).toString();
                Assert.assertEquals((String)tmp, (String)new Path(System.getProperty("java.io.tmpdir")).makeQualified(this.localFs).toString());
            } else {
                Assert.fail((String)("Temp directory " + this.tmpDir + " doesnt exist."));
            }
            File tmpFile = File.createTempFile("test", ".tmp");
            Assert.assertEquals((String)tmp, (String)new Path(tmpFile.getParent()).makeQualified(this.localFs).toString());
        }

        public void configure(JobConf job) {
            this.tmpDir = new Path(job.get("mapred.child.tmp", "./tmp"));
            try {
                this.localFs = FileSystem.getLocal((Configuration)job);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Assert.fail((String)"IOException in getting localFS");
            }
        }
    }
}

