/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NLineInputFormat;

public class TestLineInputFormat
extends TestCase {
    private static int MAX_LENGTH = 200;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        Path file = new Path(workDir, "test.txt");
        int seed = new Random().nextInt();
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        int numLinesPerMap = 5;
        job.setInt("mapred.line.input.format.linespermap", numLinesPerMap);
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            this.checkFormat(job, numLinesPerMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFormat(JobConf job, int expectedN) throws IOException {
        NLineInputFormat format = new NLineInputFormat();
        format.configure(job);
        int ignoredNumSplits = 1;
        InputSplit[] splits = format.getSplits(job, ignoredNumSplits);
        int count = 0;
        for (int j = 0; j < splits.length - 1; ++j) {
            TestLineInputFormat.assertEquals((String)"There are no split locations", (int)0, (int)splits[j].getLocations().length);
            RecordReader reader = format.getRecordReader(splits[j], job, voidReporter);
            Class<?> readerClass = reader.getClass();
            TestLineInputFormat.assertEquals((String)"reader class is LineRecordReader.", LineRecordReader.class, readerClass);
            LongWritable key = (LongWritable)reader.createKey();
            Class<?> keyClass = key.getClass();
            TestLineInputFormat.assertEquals((String)"Key class is LongWritable.", LongWritable.class, keyClass);
            Text value = (Text)reader.createValue();
            Class<?> valueClass = value.getClass();
            TestLineInputFormat.assertEquals((String)"Value class is Text.", Text.class, valueClass);
            try {
                count = 0;
                while (reader.next((Object)key, (Object)value)) {
                    ++count;
                }
            }
            finally {
                reader.close();
            }
            TestLineInputFormat.assertEquals((String)("number of lines in split is " + expectedN), (int)expectedN, (int)count);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestLineInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestLineInputFormat");
        voidReporter = Reporter.NULL;
    }
}

