/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class TestFileInputFormat
extends TestCase {
    public void testAddInputPath() throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "s3://abc:xyz@hostname/");
        Job j = new Job(conf);
        FileSystem defaultfs = FileSystem.get((Configuration)conf);
        System.out.println("defaultfs.getUri() = " + defaultfs.getUri());
        Path original = new Path("file:/foo");
        System.out.println("original = " + original);
        FileInputFormat.addInputPath((Job)j, (Path)original);
        Path[] results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        TestFileInputFormat.assertEquals((int)1, (int)results.length);
        TestFileInputFormat.assertEquals((Object)original, (Object)results[0]);
        original = new Path("file:/bar");
        System.out.println("original = " + original);
        FileInputFormat.setInputPaths((Job)j, (Path[])new Path[]{original});
        results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        TestFileInputFormat.assertEquals((int)1, (int)results.length);
        TestFileInputFormat.assertEquals((Object)original, (Object)results[0]);
    }
}

