/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class TestMultipleInputs
extends TestCase {
    public void testAddInputPathWithFormat() throws IOException {
        Job job = new Job();
        MultipleInputs.addInputPath((Job)job, (Path)new Path("/foo"), TextInputFormat.class);
        MultipleInputs.addInputPath((Job)job, (Path)new Path("/bar"), KeyValueTextInputFormat.class);
        Map inputs = MultipleInputs.getInputFormatMap((JobContext)new JobContext(job.getConfiguration(), new JobID()));
        TestMultipleInputs.assertEquals(TextInputFormat.class, ((InputFormat)inputs.get(new Path("/foo"))).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, ((InputFormat)inputs.get(new Path("/bar"))).getClass());
    }

    public void testAddInputPathWithMapper() throws IOException {
        Job job = new Job();
        MultipleInputs.addInputPath((Job)job, (Path)new Path("/foo"), TextInputFormat.class, MapClass.class);
        MultipleInputs.addInputPath((Job)job, (Path)new Path("/bar"), KeyValueTextInputFormat.class, MapClass2.class);
        Map inputs = MultipleInputs.getInputFormatMap((JobContext)job);
        Map maps = MultipleInputs.getMapperTypeMap((JobContext)job);
        TestMultipleInputs.assertEquals(TextInputFormat.class, ((InputFormat)inputs.get(new Path("/foo"))).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, ((InputFormat)inputs.get(new Path("/bar"))).getClass());
        TestMultipleInputs.assertEquals(MapClass.class, maps.get(new Path("/foo")));
        TestMultipleInputs.assertEquals(MapClass2.class, maps.get(new Path("/bar")));
    }

    static class MapClass2
    extends MapClass {
        MapClass2() {
        }
    }

    static class MapClass
    extends Mapper<String, String, String, String> {
        MapClass() {
        }
    }
}

