/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TestMultipleOutputs
extends HadoopTestCase {
    private static final Path ROOT_DIR = new Path("testing/mo");
    private static final Path IN_DIR = new Path(ROOT_DIR, "input");
    private static final Path OUT_DIR = new Path(ROOT_DIR, "output");

    public TestMultipleOutputs() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testWithoutCounters() throws Exception {
        this._testMultipleOutputs(false);
    }

    public void testWithCounters() throws Exception {
        this._testMultipleOutputs(true);
    }

    private Path getDir(Path dir) {
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            dir = new Path(localPathRoot, dir);
        }
        return dir;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Path rootDir = this.getDir(ROOT_DIR);
        Path inDir = this.getDir(IN_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
    }

    @Override
    public void tearDown() throws Exception {
        Path rootDir = this.getDir(ROOT_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
        super.tearDown();
    }

    protected void _testMultipleOutputs(boolean withCounters) throws Exception {
        FileStatus[] statuses;
        Path inDir = this.getDir(IN_DIR);
        Path outDir = this.getDir(OUT_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        file = fs.create(new Path(inDir, "part-1"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        Job job = new Job((Configuration)conf);
        job.setJobName("mo");
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        MultipleOutputs.addNamedOutput((Job)job, (String)"text", TextOutputFormat.class, LongWritable.class, Text.class);
        MultipleOutputs.setCountersEnabled((Job)job, (boolean)withCounters);
        job.setMapperClass(MOMap.class);
        job.setReducerClass(MOReduce.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        job.waitForCompletion(false);
        int namedOutputCount = 0;
        for (FileStatus status : statuses = fs.listStatus(outDir)) {
            if (!status.getPath().getName().equals("text-m-00000") && !status.getPath().getName().equals("text-m-00001") && !status.getPath().getName().equals("text-r-00000")) continue;
            ++namedOutputCount;
        }
        TestMultipleOutputs.assertEquals((int)3, (int)namedOutputCount);
        JobContext jobContext = new JobContext(job.getConfiguration(), new JobID());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(FileOutputFormat.getOutputPath((JobContext)jobContext), "text-r-00000"))));
        int count = 0;
        String line = reader.readLine();
        while (line != null) {
            TestMultipleOutputs.assertTrue((boolean)line.endsWith("text"));
            line = reader.readLine();
            ++count;
        }
        reader.close();
        TestMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        CounterGroup counters = job.getCounters().getGroup(MultipleOutputs.class.getName());
        if (!withCounters) {
            TestMultipleOutputs.assertEquals((int)0, (int)counters.size());
        } else {
            TestMultipleOutputs.assertEquals((int)1, (int)counters.size());
            TestMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter("text").getValue());
        }
    }

    public static class MOReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        private MultipleOutputs mos;

        protected void setup(Reducer.Context context) {
            this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        }

        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text value : values) {
                if (!value.toString().equals("b")) {
                    context.write((Object)key, (Object)value);
                    continue;
                }
                this.mos.write("text", (Object)key, (Object)new Text("text"));
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.mos.close();
        }
    }

    public static class MOMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        private MultipleOutputs mos;

        protected void setup(Mapper.Context context) {
            this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (!value.toString().equals("a")) {
                context.write((Object)key, (Object)value);
            } else {
                this.mos.write("text", (Object)key, (Object)new Text("text"));
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.mos.close();
        }
    }
}

