/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDelegationTokenRenewal {
    private static final Log LOG = LogFactory.getLog(TestDelegationTokenRenewal.class);
    private static final Text KIND = new Text("TestDelegationTokenRenewal.Token");
    private static Configuration conf;
    private static String trackerService;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.set("mapred.job.tracker", trackerService);
        InetAddress iaddr = InetAddress.getByName("localhost");
        String dnsName = iaddr.getCanonicalHostName();
        URI uri = new URI("hdfs://" + dnsName + ":" + "0");
        conf.setClass("fs." + uri.getScheme() + ".impl", MyFS.class, DistributedFileSystem.class);
        FileSystem.setDefaultUri((Configuration)conf, (URI)uri);
        LOG.info((Object)("filesystem uri = " + FileSystem.getDefaultUri((Configuration)conf).toString()));
    }

    static MyToken createTokens(Text renewer) throws IOException {
        Text user1 = new Text("user1");
        MyDelegationTokenSecretManager sm = new MyDelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, null);
        sm.startThreads();
        org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier dtId1 = new org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier(user1, renewer, user1);
        MyToken token1 = new MyToken(dtId1, sm);
        token1.setService(new Text("localhost:0"));
        return token1;
    }

    @Test
    public void testLocalMRTokenRenewal() throws IOException {
        String user = UserGroupInformation.getLoginUser().getUserName();
        org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier ident = new org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier(new Text(user), new Text(user), null);
        Token t = new Token(ident.getBytes(), new byte[0], DelegationTokenIdentifier.MAPREDUCE_DELEGATION_KIND, new Text("service"));
        Assert.assertTrue((boolean)t.isManaged());
        ident = new org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier(new Text(user), new Text(user + "-is-not-me"), null);
        t = new Token(ident.getBytes(), new byte[0], DelegationTokenIdentifier.MAPREDUCE_DELEGATION_KIND, new Text("service"));
        Assert.assertFalse((boolean)t.isManaged());
    }

    @Test
    public void testDTRenewal() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        MyToken token2 = dfs.getDelegationToken(new Text("user2"));
        MyToken token3 = dfs.getDelegationToken(new Text("user3"));
        Renewer.tokenToRenewIn2Sec = token1;
        LOG.info((Object)("token=" + (Object)((Object)token1) + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        String nn2 = "hdfs://host2:0";
        String nn3 = "hdfs://host3:0";
        Credentials ts = new Credentials();
        ts.addToken(new Text(nn1), (Token)token1);
        ts.addToken(new Text(nn2), (Token)token2);
        ts.addToken(new Text(nn3), (Token)token3);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)new JobID("job1", 1), (Credentials)ts, (Configuration)conf);
        int numberOfExpectedRenewals = 4;
        int attempts = 10;
        while (attempts-- > 0) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (Renewer.counter != numberOfExpectedRenewals) continue;
        }
        LOG.info((Object)("dfs=" + ((Object)((Object)dfs)).hashCode() + ";Counter = " + Renewer.counter + ";t=" + Renewer.lastRenewed));
        Assert.assertEquals((String)"renew wasn't called as many times as expected(4):", (long)numberOfExpectedRenewals, (long)Renewer.counter);
        Assert.assertEquals((String)"most recently renewed token mismatch", (Object)Renewer.lastRenewed, (Object)((Object)token1));
        ts = new Credentials();
        MyToken token4 = dfs.getDelegationToken(new Text("user4"));
        Renewer.tokenToRenewIn2Sec = token4;
        LOG.info((Object)("token=" + (Object)((Object)token4) + " should be renewed for 2 secs"));
        String nn4 = "hdfs://host4:0";
        ts.addToken(new Text(nn4), (Token)token4);
        JobID jid2 = new JobID("job2", 1);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)jid2, (Credentials)ts, (Configuration)conf);
        DelegationTokenRenewal.removeDelegationTokenRenewalForJob((JobID)jid2);
        numberOfExpectedRenewals = Renewer.counter;
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LOG.info((Object)("Counter = " + Renewer.counter + ";t=" + Renewer.lastRenewed));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.counter);
        try {
            token4.renew(conf);
            Assert.assertTrue((String)"Renewal of canceled token didn't fail", (boolean)false);
        }
        catch (SecretManager.InvalidToken ite) {
            // empty catch block
        }
    }

    static {
        trackerService = "localhost:0";
    }

    static class MyFS
    extends DistributedFileSystem {
        public void close() {
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
        }

        public MyToken getDelegationToken(Text renewer) throws IOException {
            MyToken result = TestDelegationTokenRenewal.createTokens(renewer);
            LOG.info((Object)("Called MYDFS.getdelegationtoken " + (Object)((Object)result)));
            return result;
        }
    }

    private static class MyToken
    extends Token<org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier> {
        public String status = "GOOD";
        public static final String CANCELED = "CANCELED";

        public MyToken(org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier dtId1, MyDelegationTokenSecretManager sm) {
            super((TokenIdentifier)dtId1, (SecretManager)sm);
            this.setKind(KIND);
            this.status = "GOOD";
        }

        public boolean isCanceled() {
            return this.status.equals(CANCELED);
        }

        public void cancelToken() {
            this.status = CANCELED;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("id=");
            String id = StringUtils.byteToHexString((byte[])this.getIdentifier());
            int idLen = id.length();
            sb.append(id.substring(idLen - 6));
            sb.append(";k=");
            sb.append(this.getKind());
            sb.append(";s=");
            sb.append(this.getService());
            return sb.toString();
        }
    }

    private static class MyDelegationTokenSecretManager
    extends DelegationTokenSecretManager {
        public MyDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, namesystem);
        }

        public void logUpdateMasterKey(DelegationKey key) throws IOException {
        }
    }

    public static class Renewer
    extends TokenRenewer {
        private static int counter = 0;
        private static Token<?> lastRenewed = null;
        private static Token<?> tokenToRenewIn2Sec = null;

        public boolean handleKind(Text kind) {
            return KIND.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> t, Configuration conf) throws IOException {
            MyToken token = (MyToken)t;
            if (token.isCanceled()) {
                throw new SecretManager.InvalidToken("token has been canceled");
            }
            lastRenewed = token;
            LOG.info((Object)("Called MYDFS.renewdelegationtoken " + (Object)((Object)token) + ";this dfs=" + ((Object)((Object)this)).hashCode() + ";c=" + ++counter));
            if (tokenToRenewIn2Sec == token) {
                LOG.info((Object)"RENEW in 2 seconds");
                tokenToRenewIn2Sec = null;
                return 2000L + System.currentTimeMillis();
            }
            return 86400000L + System.currentTimeMillis();
        }

        public void cancel(Token<?> t, Configuration conf) {
            MyToken token = (MyToken)t;
            LOG.info((Object)("Cancel token " + (Object)((Object)token)));
            token.cancelToken();
        }
    }
}

