/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

public class TestBlockLimits
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithLimits() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            Configuration conf = new Configuration();
            conf.setInt("mapreduce.job.max.split.locations", 10);
            mr = new MiniMRCluster(2, "file:///", 3, null, null, new JobConf(conf));
            this.runCustomFormat(mr);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomFormat(MiniMRCluster mr) throws IOException {
        JobConf job = new JobConf((Configuration)mr.createJobConf());
        job.setInt("mapreduce.job.max.split.locations", 100);
        FileSystem fileSys = FileSystem.get((Configuration)job);
        Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
        Path outDir = new Path(testDir, "out");
        System.out.println("testDir= " + testDir);
        fileSys.delete(testDir, true);
        job.setInputFormat(MyInputFormat.class);
        job.setOutputFormat(MyOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(MyMapper.class);
        job.setNumReduceTasks(0);
        job.set("non.std.out", outDir.toString());
        try {
            JobClient.runJob((JobConf)job);
            TestBlockLimits.fail((String)"JobTracker neglected to fail misconfigured job");
        }
        catch (IOException ie) {
            System.out.println("Failed job " + StringUtils.stringifyException((Throwable)ie));
        }
        finally {
            fileSys.delete(testDir, true);
        }
    }

    static class MyOutputFormat
    implements OutputFormat {
        MyOutputFormat() {
        }

        public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            return new MyRecordWriter(new Path(job.get("non.std.out")), job);
        }

        public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        }

        static class MyRecordWriter
        implements RecordWriter<Object, Object> {
            private DataOutputStream out;

            public MyRecordWriter(Path outputFile, JobConf job) throws IOException {
            }

            public void write(Object key, Object value) throws IOException {
            }

            public void close(Reporter reporter) throws IOException {
            }
        }
    }

    private static class MyInputFormat
    implements InputFormat<Text, Text> {
        private MyInputFormat() {
        }

        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            return new MySplit[]{new MySplit(0, 1), new MySplit(1, 3), new MySplit(4, 2)};
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            MySplit sp = (MySplit)split;
            return new RecordReader<Text, Text>(){

                public boolean next(Text key, Text value) {
                    return false;
                }

                public Text createKey() {
                    return new Text();
                }

                public Text createValue() {
                    return new Text();
                }

                public long getPos() throws IOException {
                    return 0L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 1.0f;
                }
            };
        }

        private static class MySplit
        implements InputSplit {
            int first;
            int length;

            public MySplit() {
            }

            public MySplit(int first, int length) {
                this.first = first;
                this.length = length;
            }

            public String[] getLocations() {
                Object[] ret = new String[200];
                Arrays.fill(ret, "SPLIT");
                return ret;
            }

            public long getLength() {
                return this.length;
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVInt((DataOutput)out, (int)this.first);
                WritableUtils.writeVInt((DataOutput)out, (int)this.length);
            }

            public void readFields(DataInput in) throws IOException {
                this.first = WritableUtils.readVInt((DataInput)in);
                this.length = WritableUtils.readVInt((DataInput)in);
            }
        }
    }

    static class MyMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        MyMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
        }
    }
}

