/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecRecord0;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordComparator;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.Utils;
import org.apache.hadoop.record.meta.FieldTypeInfo;
import org.apache.hadoop.record.meta.MapTypeID;
import org.apache.hadoop.record.meta.RecordTypeInfo;
import org.apache.hadoop.record.meta.StructTypeID;
import org.apache.hadoop.record.meta.TypeID;
import org.apache.hadoop.record.meta.VectorTypeID;

public class RecRecord1
extends Record {
    private static final RecordTypeInfo _rio_recTypeInfo = new RecordTypeInfo("RecRecord1");
    private static RecordTypeInfo _rio_rtiFilter;
    private static int[] _rio_rtiFilterFields;
    private boolean boolVal;
    private byte byteVal;
    private int intVal;
    private long longVal;
    private float floatVal;
    private double doubleVal;
    private String stringVal;
    private Buffer bufferVal;
    private ArrayList<String> vectorVal;
    private TreeMap<String, String> mapVal;
    private RecRecord0 recordVal;

    public RecRecord1() {
    }

    public RecRecord1(boolean boolVal, byte byteVal, int intVal, long longVal, float floatVal, double doubleVal, String stringVal, Buffer bufferVal, ArrayList<String> vectorVal, TreeMap<String, String> mapVal, RecRecord0 recordVal) {
        this.boolVal = boolVal;
        this.byteVal = byteVal;
        this.intVal = intVal;
        this.longVal = longVal;
        this.floatVal = floatVal;
        this.doubleVal = doubleVal;
        this.stringVal = stringVal;
        this.bufferVal = bufferVal;
        this.vectorVal = vectorVal;
        this.mapVal = mapVal;
        this.recordVal = recordVal;
    }

    public static RecordTypeInfo getTypeInfo() {
        return _rio_recTypeInfo;
    }

    public static void setTypeFilter(RecordTypeInfo rti) {
        if (null == rti) {
            return;
        }
        _rio_rtiFilter = rti;
        _rio_rtiFilterFields = null;
        RecRecord0.setTypeFilter(rti.getNestedStructTypeInfo("RecRecord0"));
    }

    private static void setupRtiFields() {
        int _rio_i;
        if (null == _rio_rtiFilter) {
            return;
        }
        if (null != _rio_rtiFilterFields) {
            return;
        }
        _rio_rtiFilterFields = new int[_rio_rtiFilter.getFieldTypeInfos().size()];
        for (_rio_i = 0; _rio_i < _rio_rtiFilterFields.length; ++_rio_i) {
            RecRecord1._rio_rtiFilterFields[_rio_i] = 0;
        }
        Iterator _rio_itFilter = _rio_rtiFilter.getFieldTypeInfos().iterator();
        _rio_i = 0;
        while (_rio_itFilter.hasNext()) {
            FieldTypeInfo _rio_tInfoFilter = (FieldTypeInfo)_rio_itFilter.next();
            Iterator _rio_it = _rio_recTypeInfo.getFieldTypeInfos().iterator();
            int _rio_j = 1;
            while (_rio_it.hasNext()) {
                FieldTypeInfo _rio_tInfo = (FieldTypeInfo)_rio_it.next();
                if (_rio_tInfo.equals(_rio_tInfoFilter)) {
                    RecRecord1._rio_rtiFilterFields[_rio_i] = _rio_j;
                    break;
                }
                ++_rio_j;
            }
            ++_rio_i;
        }
    }

    public boolean getBoolVal() {
        return this.boolVal;
    }

    public void setBoolVal(boolean boolVal) {
        this.boolVal = boolVal;
    }

    public byte getByteVal() {
        return this.byteVal;
    }

    public void setByteVal(byte byteVal) {
        this.byteVal = byteVal;
    }

    public int getIntVal() {
        return this.intVal;
    }

    public void setIntVal(int intVal) {
        this.intVal = intVal;
    }

    public long getLongVal() {
        return this.longVal;
    }

    public void setLongVal(long longVal) {
        this.longVal = longVal;
    }

    public float getFloatVal() {
        return this.floatVal;
    }

    public void setFloatVal(float floatVal) {
        this.floatVal = floatVal;
    }

    public double getDoubleVal() {
        return this.doubleVal;
    }

    public void setDoubleVal(double doubleVal) {
        this.doubleVal = doubleVal;
    }

    public String getStringVal() {
        return this.stringVal;
    }

    public void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    public Buffer getBufferVal() {
        return this.bufferVal;
    }

    public void setBufferVal(Buffer bufferVal) {
        this.bufferVal = bufferVal;
    }

    public ArrayList<String> getVectorVal() {
        return this.vectorVal;
    }

    public void setVectorVal(ArrayList<String> vectorVal) {
        this.vectorVal = vectorVal;
    }

    public TreeMap<String, String> getMapVal() {
        return this.mapVal;
    }

    public void setMapVal(TreeMap<String, String> mapVal) {
        this.mapVal = mapVal;
    }

    public RecRecord0 getRecordVal() {
        return this.recordVal;
    }

    public void setRecordVal(RecRecord0 recordVal) {
        this.recordVal = recordVal;
    }

    public void serialize(RecordOutput _rio_a, String _rio_tag) throws IOException {
        _rio_a.startRecord((Record)this, _rio_tag);
        _rio_a.writeBool(this.boolVal, "boolVal");
        _rio_a.writeByte(this.byteVal, "byteVal");
        _rio_a.writeInt(this.intVal, "intVal");
        _rio_a.writeLong(this.longVal, "longVal");
        _rio_a.writeFloat(this.floatVal, "floatVal");
        _rio_a.writeDouble(this.doubleVal, "doubleVal");
        _rio_a.writeString(this.stringVal, "stringVal");
        _rio_a.writeBuffer(this.bufferVal, "bufferVal");
        _rio_a.startVector(this.vectorVal, "vectorVal");
        int _rio_len1 = this.vectorVal.size();
        for (int _rio_vidx1 = 0; _rio_vidx1 < _rio_len1; ++_rio_vidx1) {
            String _rio_e1 = this.vectorVal.get(_rio_vidx1);
            _rio_a.writeString(_rio_e1, "_rio_e1");
        }
        _rio_a.endVector(this.vectorVal, "vectorVal");
        _rio_a.startMap(this.mapVal, "mapVal");
        Set<Map.Entry<String, String>> _rio_es1 = this.mapVal.entrySet();
        for (Map.Entry<String, String> _rio_me1 : _rio_es1) {
            String _rio_k1 = _rio_me1.getKey();
            String _rio_v1 = _rio_me1.getValue();
            _rio_a.writeString(_rio_k1, "_rio_k1");
            _rio_a.writeString(_rio_v1, "_rio_v1");
        }
        _rio_a.endMap(this.mapVal, "mapVal");
        this.recordVal.serialize(_rio_a, "recordVal");
        _rio_a.endRecord((Record)this, _rio_tag);
    }

    private void deserializeWithoutFilter(RecordInput _rio_a, String _rio_tag) throws IOException {
        _rio_a.startRecord(_rio_tag);
        this.boolVal = _rio_a.readBool("boolVal");
        this.byteVal = _rio_a.readByte("byteVal");
        this.intVal = _rio_a.readInt("intVal");
        this.longVal = _rio_a.readLong("longVal");
        this.floatVal = _rio_a.readFloat("floatVal");
        this.doubleVal = _rio_a.readDouble("doubleVal");
        this.stringVal = _rio_a.readString("stringVal");
        this.bufferVal = _rio_a.readBuffer("bufferVal");
        Index _rio_vidx1 = _rio_a.startVector("vectorVal");
        this.vectorVal = new ArrayList();
        while (!_rio_vidx1.done()) {
            String _rio_e1 = _rio_a.readString("_rio_e1");
            this.vectorVal.add(_rio_e1);
            _rio_vidx1.incr();
        }
        _rio_a.endVector("vectorVal");
        Index _rio_midx1 = _rio_a.startMap("mapVal");
        this.mapVal = new TreeMap();
        while (!_rio_midx1.done()) {
            String _rio_k1 = _rio_a.readString("_rio_k1");
            String _rio_v1 = _rio_a.readString("_rio_v1");
            this.mapVal.put(_rio_k1, _rio_v1);
            _rio_midx1.incr();
        }
        _rio_a.endMap("mapVal");
        this.recordVal = new RecRecord0();
        this.recordVal.deserialize(_rio_a, "recordVal");
        _rio_a.endRecord(_rio_tag);
    }

    public void deserialize(RecordInput _rio_a, String _rio_tag) throws IOException {
        if (null == _rio_rtiFilter) {
            this.deserializeWithoutFilter(_rio_a, _rio_tag);
            return;
        }
        _rio_a.startRecord(_rio_tag);
        RecRecord1.setupRtiFields();
        for (int _rio_i = 0; _rio_i < _rio_rtiFilter.getFieldTypeInfos().size(); ++_rio_i) {
            if (1 == _rio_rtiFilterFields[_rio_i]) {
                this.boolVal = _rio_a.readBool("boolVal");
                continue;
            }
            if (2 == _rio_rtiFilterFields[_rio_i]) {
                this.byteVal = _rio_a.readByte("byteVal");
                continue;
            }
            if (3 == _rio_rtiFilterFields[_rio_i]) {
                this.intVal = _rio_a.readInt("intVal");
                continue;
            }
            if (4 == _rio_rtiFilterFields[_rio_i]) {
                this.longVal = _rio_a.readLong("longVal");
                continue;
            }
            if (5 == _rio_rtiFilterFields[_rio_i]) {
                this.floatVal = _rio_a.readFloat("floatVal");
                continue;
            }
            if (6 == _rio_rtiFilterFields[_rio_i]) {
                this.doubleVal = _rio_a.readDouble("doubleVal");
                continue;
            }
            if (7 == _rio_rtiFilterFields[_rio_i]) {
                this.stringVal = _rio_a.readString("stringVal");
                continue;
            }
            if (8 == _rio_rtiFilterFields[_rio_i]) {
                this.bufferVal = _rio_a.readBuffer("bufferVal");
                continue;
            }
            if (9 == _rio_rtiFilterFields[_rio_i]) {
                Index _rio_vidx1 = _rio_a.startVector("vectorVal");
                this.vectorVal = new ArrayList();
                while (!_rio_vidx1.done()) {
                    String _rio_e1 = _rio_a.readString("_rio_e1");
                    this.vectorVal.add(_rio_e1);
                    _rio_vidx1.incr();
                }
                _rio_a.endVector("vectorVal");
                continue;
            }
            if (10 == _rio_rtiFilterFields[_rio_i]) {
                Index _rio_midx1 = _rio_a.startMap("mapVal");
                this.mapVal = new TreeMap();
                while (!_rio_midx1.done()) {
                    String _rio_k1 = _rio_a.readString("_rio_k1");
                    String _rio_v1 = _rio_a.readString("_rio_v1");
                    this.mapVal.put(_rio_k1, _rio_v1);
                    _rio_midx1.incr();
                }
                _rio_a.endMap("mapVal");
                continue;
            }
            if (11 == _rio_rtiFilterFields[_rio_i]) {
                this.recordVal = new RecRecord0();
                this.recordVal.deserialize(_rio_a, "recordVal");
                continue;
            }
            ArrayList typeInfos = (ArrayList)_rio_rtiFilter.getFieldTypeInfos();
            org.apache.hadoop.record.meta.Utils.skip((RecordInput)_rio_a, (String)((FieldTypeInfo)typeInfos.get(_rio_i)).getFieldID(), (TypeID)((FieldTypeInfo)typeInfos.get(_rio_i)).getTypeID());
        }
        _rio_a.endRecord(_rio_tag);
    }

    public int compareTo(Object _rio_peer_) throws ClassCastException {
        if (!(_rio_peer_ instanceof RecRecord1)) {
            throw new ClassCastException("Comparing different types of records.");
        }
        RecRecord1 _rio_peer = (RecRecord1)((Object)_rio_peer_);
        int _rio_ret = 0;
        int n = this.boolVal == _rio_peer.boolVal ? 0 : (_rio_ret = this.boolVal ? 1 : -1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int n2 = this.byteVal == _rio_peer.byteVal ? 0 : (_rio_ret = this.byteVal < _rio_peer.byteVal ? -1 : 1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int n3 = this.intVal == _rio_peer.intVal ? 0 : (_rio_ret = this.intVal < _rio_peer.intVal ? -1 : 1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int n4 = this.longVal == _rio_peer.longVal ? 0 : (_rio_ret = this.longVal < _rio_peer.longVal ? -1 : 1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int n5 = this.floatVal == _rio_peer.floatVal ? 0 : (_rio_ret = this.floatVal < _rio_peer.floatVal ? -1 : 1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int n6 = this.doubleVal == _rio_peer.doubleVal ? 0 : (_rio_ret = this.doubleVal < _rio_peer.doubleVal ? -1 : 1);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        _rio_ret = this.stringVal.compareTo(_rio_peer.stringVal);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        _rio_ret = this.bufferVal.compareTo((Object)_rio_peer.bufferVal);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        int _rio_len11 = this.vectorVal.size();
        int _rio_len21 = _rio_peer.vectorVal.size();
        for (int _rio_vidx1 = 0; _rio_vidx1 < _rio_len11 && _rio_vidx1 < _rio_len21; ++_rio_vidx1) {
            String _rio_e21;
            String _rio_e11 = this.vectorVal.get(_rio_vidx1);
            _rio_ret = _rio_e11.compareTo(_rio_e21 = _rio_peer.vectorVal.get(_rio_vidx1));
            if (_rio_ret == 0) continue;
            return _rio_ret;
        }
        _rio_ret = _rio_len11 - _rio_len21;
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        Set<String> _rio_set10 = this.mapVal.keySet();
        Set<String> _rio_set20 = _rio_peer.mapVal.keySet();
        Iterator<String> _rio_miter10 = _rio_set10.iterator();
        Iterator<String> _rio_miter20 = _rio_set20.iterator();
        while (_rio_miter10.hasNext() && _rio_miter20.hasNext()) {
            String _rio_k20;
            String _rio_k10 = _rio_miter10.next();
            _rio_ret = _rio_k10.compareTo(_rio_k20 = _rio_miter20.next());
            if (_rio_ret == 0) continue;
            return _rio_ret;
        }
        _rio_ret = _rio_set10.size() - _rio_set20.size();
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        _rio_ret = this.recordVal.compareTo((Object)_rio_peer.recordVal);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        return _rio_ret;
    }

    public boolean equals(Object _rio_peer_) {
        if (!(_rio_peer_ instanceof RecRecord1)) {
            return false;
        }
        if (_rio_peer_ == this) {
            return true;
        }
        RecRecord1 _rio_peer = (RecRecord1)((Object)_rio_peer_);
        boolean _rio_ret = false;
        boolean bl = _rio_ret = this.boolVal == _rio_peer.boolVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        boolean bl2 = _rio_ret = this.byteVal == _rio_peer.byteVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        boolean bl3 = _rio_ret = this.intVal == _rio_peer.intVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        boolean bl4 = _rio_ret = this.longVal == _rio_peer.longVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        boolean bl5 = _rio_ret = this.floatVal == _rio_peer.floatVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        boolean bl6 = _rio_ret = this.doubleVal == _rio_peer.doubleVal;
        if (!_rio_ret) {
            return _rio_ret;
        }
        _rio_ret = this.stringVal.equals(_rio_peer.stringVal);
        if (!_rio_ret) {
            return _rio_ret;
        }
        _rio_ret = this.bufferVal.equals((Object)_rio_peer.bufferVal);
        if (!_rio_ret) {
            return _rio_ret;
        }
        _rio_ret = this.vectorVal.equals(_rio_peer.vectorVal);
        if (!_rio_ret) {
            return _rio_ret;
        }
        _rio_ret = this.mapVal.equals(_rio_peer.mapVal);
        if (!_rio_ret) {
            return _rio_ret;
        }
        _rio_ret = this.recordVal.equals((Object)_rio_peer.recordVal);
        if (!_rio_ret) {
            return _rio_ret;
        }
        return _rio_ret;
    }

    public Object clone() throws CloneNotSupportedException {
        RecRecord1 _rio_other = new RecRecord1();
        _rio_other.boolVal = this.boolVal;
        _rio_other.byteVal = this.byteVal;
        _rio_other.intVal = this.intVal;
        _rio_other.longVal = this.longVal;
        _rio_other.floatVal = this.floatVal;
        _rio_other.doubleVal = this.doubleVal;
        _rio_other.stringVal = this.stringVal;
        _rio_other.bufferVal = (Buffer)this.bufferVal.clone();
        _rio_other.vectorVal = (ArrayList)this.vectorVal.clone();
        _rio_other.mapVal = (TreeMap)this.mapVal.clone();
        _rio_other.recordVal = (RecRecord0)((Object)this.recordVal.clone());
        return _rio_other;
    }

    public int hashCode() {
        int _rio_result = 17;
        int _rio_ret = this.boolVal ? 0 : 1;
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.byteVal;
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.intVal;
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = (int)(this.longVal ^ this.longVal >>> 32);
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = Float.floatToIntBits(this.floatVal);
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = (int)(Double.doubleToLongBits(this.doubleVal) ^ Double.doubleToLongBits(this.doubleVal) >>> 32);
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.stringVal.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.bufferVal.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.vectorVal.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.mapVal.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        _rio_ret = this.recordVal.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        return _rio_result;
    }

    public static String signature() {
        return "LRecRecord1(zbilfdsB[s]{ss}LRecRecord0(s))";
    }

    static {
        _rio_recTypeInfo.addField("boolVal", TypeID.BoolTypeID);
        _rio_recTypeInfo.addField("byteVal", TypeID.ByteTypeID);
        _rio_recTypeInfo.addField("intVal", TypeID.IntTypeID);
        _rio_recTypeInfo.addField("longVal", TypeID.LongTypeID);
        _rio_recTypeInfo.addField("floatVal", TypeID.FloatTypeID);
        _rio_recTypeInfo.addField("doubleVal", TypeID.DoubleTypeID);
        _rio_recTypeInfo.addField("stringVal", TypeID.StringTypeID);
        _rio_recTypeInfo.addField("bufferVal", TypeID.BufferTypeID);
        _rio_recTypeInfo.addField("vectorVal", (TypeID)new VectorTypeID(TypeID.StringTypeID));
        _rio_recTypeInfo.addField("mapVal", (TypeID)new MapTypeID(TypeID.StringTypeID, TypeID.StringTypeID));
        _rio_recTypeInfo.addField("recordVal", (TypeID)new StructTypeID(RecRecord0.getTypeInfo()));
        RecordComparator.define(RecRecord1.class, (RecordComparator)new Comparator());
    }

    public static class Comparator
    extends RecordComparator {
        public Comparator() {
            super(RecRecord1.class);
        }

        public static int slurpRaw(byte[] b, int s, int l) {
            try {
                int z;
                int i;
                int os = s++;
                if (l < 1) {
                    throw new IOException("Boolean is exactly 1 byte. Provided buffer is smaller.");
                }
                if (--l < 1) {
                    throw new IOException("Byte is exactly 1 byte. Provided buffer is smaller.");
                }
                --l;
                int i2 = Utils.readVInt((byte[])b, (int)(++s));
                int z2 = Utils.getVIntSize((long)i2);
                l -= z2;
                long i22 = Utils.readVLong((byte[])b, (int)(s += z2));
                int z3 = Utils.getVIntSize((long)i22);
                s += z3;
                if ((l -= z3) < 4) {
                    throw new IOException("Float is exactly 4 bytes. Provided buffer is smaller.");
                }
                s += 4;
                if ((l -= 4) < 8) {
                    throw new IOException("Double is exactly 8 bytes. Provided buffer is smaller.");
                }
                l -= 8;
                i = Utils.readVInt((byte[])b, (int)(s += 8));
                z2 = Utils.getVIntSize((long)i);
                s += z2 + i;
                l -= z2 + i;
                i = Utils.readVInt((byte[])b, (int)s);
                z2 = Utils.getVIntSize((long)i);
                l -= z2 + i;
                int vi1 = Utils.readVInt((byte[])b, (int)(s += z2 + i));
                int vz1 = Utils.getVIntSize((long)vi1);
                s += vz1;
                l -= vz1;
                for (int vidx1 = 0; vidx1 < vi1; ++vidx1) {
                    i = Utils.readVInt((byte[])b, (int)s);
                    z = Utils.getVIntSize((long)i);
                    s += z + i;
                    l -= z + i;
                }
                int mi1 = Utils.readVInt((byte[])b, (int)s);
                int mz1 = Utils.getVIntSize((long)mi1);
                s += mz1;
                l -= mz1;
                for (int midx1 = 0; midx1 < mi1; ++midx1) {
                    i = Utils.readVInt((byte[])b, (int)s);
                    z = Utils.getVIntSize((long)i);
                    s += z + i;
                    l -= z + i;
                    i = Utils.readVInt((byte[])b, (int)s);
                    z = Utils.getVIntSize((long)i);
                    s += z + i;
                    l -= z + i;
                }
                int r = RecRecord0.Comparator.slurpRaw(b, s, l);
                l -= r;
                return os - (s += r);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static int compareRaw(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int r1;
                int z2;
                int z1;
                int i2;
                int i1;
                double d2;
                float f2;
                long i22;
                int i23;
                int i12;
                int os1 = s1;
                if (l1 < 1 || l2 < 1) {
                    throw new IOException("Boolean is exactly 1 byte. Provided buffer is smaller.");
                }
                if (b1[s1] != b2[s2]) {
                    return b1[s1] < b2[s2] ? -1 : 0;
                }
                ++s1;
                ++s2;
                if (--l1 < 1 || --l2 < 1) {
                    throw new IOException("Byte is exactly 1 byte. Provided buffer is smaller.");
                }
                if (b1[s1] != b2[s2]) {
                    return b1[s1] < b2[s2] ? -1 : 0;
                }
                --l1;
                --l2;
                if ((i12 = Utils.readVInt((byte[])b1, (int)(++s1))) != (i23 = Utils.readVInt((byte[])b2, (int)(++s2)))) {
                    return i12 - i23 < 0 ? -1 : 0;
                }
                int z12 = Utils.getVIntSize((long)i12);
                int z22 = Utils.getVIntSize((long)i23);
                l1 -= z12;
                l2 -= z22;
                long i3 = Utils.readVLong((byte[])b1, (int)(s1 += z12));
                if (i3 != (i22 = Utils.readVLong((byte[])b2, (int)(s2 += z22)))) {
                    return i3 - i22 < 0L ? -1 : 0;
                }
                int z13 = Utils.getVIntSize((long)i3);
                int z23 = Utils.getVIntSize((long)i22);
                s1 += z13;
                s2 += z23;
                if ((l1 -= z13) < 4 || (l2 -= z23) < 4) {
                    throw new IOException("Float is exactly 4 bytes. Provided buffer is smaller.");
                }
                float f1 = Utils.readFloat((byte[])b1, (int)s1);
                if (f1 != (f2 = Utils.readFloat((byte[])b2, (int)s2))) {
                    return f1 - f2 < 0.0f ? -1 : 0;
                }
                s1 += 4;
                s2 += 4;
                if ((l1 -= 4) < 8 || (l2 -= 4) < 8) {
                    throw new IOException("Double is exactly 8 bytes. Provided buffer is smaller.");
                }
                double d1 = Utils.readDouble((byte[])b1, (int)s1);
                if (d1 != (d2 = Utils.readDouble((byte[])b2, (int)s2))) {
                    return d1 - d2 < 0.0 ? -1 : 0;
                }
                l1 -= 8;
                l2 -= 8;
                i1 = Utils.readVInt((byte[])b1, (int)(s1 += 8));
                i2 = Utils.readVInt((byte[])b2, (int)(s2 += 8));
                z1 = Utils.getVIntSize((long)i1);
                z22 = Utils.getVIntSize((long)i2);
                l1 -= z1;
                l2 -= z22;
                int r12 = Utils.compareBytes((byte[])b1, (int)(s1 += z1), (int)i1, (byte[])b2, (int)(s2 += z22), (int)i2);
                if (r12 != 0) {
                    return r12 < 0 ? -1 : 0;
                }
                s1 += i1;
                s2 += i2;
                l1 -= i1;
                l1 -= i2;
                i1 = Utils.readVInt((byte[])b1, (int)s1);
                i2 = Utils.readVInt((byte[])b2, (int)s2);
                z1 = Utils.getVIntSize((long)i1);
                z22 = Utils.getVIntSize((long)i2);
                l1 -= z1;
                l2 -= z22;
                r12 = Utils.compareBytes((byte[])b1, (int)(s1 += z1), (int)i1, (byte[])b2, (int)(s2 += z22), (int)i2);
                if (r12 != 0) {
                    return r12 < 0 ? -1 : 0;
                }
                l1 -= i1;
                l1 -= i2;
                int vi11 = Utils.readVInt((byte[])b1, (int)(s1 += i1));
                int vi21 = Utils.readVInt((byte[])b2, (int)(s2 += i2));
                int vz11 = Utils.getVIntSize((long)vi11);
                int vz21 = Utils.getVIntSize((long)vi21);
                s1 += vz11;
                s2 += vz21;
                l1 -= vz11;
                l2 -= vz21;
                for (int vidx1 = 0; vidx1 < vi11 && vidx1 < vi21; ++vidx1) {
                    i1 = Utils.readVInt((byte[])b1, (int)s1);
                    i2 = Utils.readVInt((byte[])b2, (int)s2);
                    z1 = Utils.getVIntSize((long)i1);
                    z2 = Utils.getVIntSize((long)i2);
                    l1 -= z1;
                    l2 -= z2;
                    r1 = Utils.compareBytes((byte[])b1, (int)(s1 += z1), (int)i1, (byte[])b2, (int)(s2 += z2), (int)i2);
                    if (r1 != 0) {
                        return r1 < 0 ? -1 : 0;
                    }
                    s1 += i1;
                    s2 += i2;
                    l1 -= i1;
                    l1 -= i2;
                }
                if (vi11 != vi21) {
                    return vi11 < vi21 ? -1 : 0;
                }
                int mi11 = Utils.readVInt((byte[])b1, (int)s1);
                int mi21 = Utils.readVInt((byte[])b2, (int)s2);
                int mz11 = Utils.getVIntSize((long)mi11);
                int mz21 = Utils.getVIntSize((long)mi21);
                s1 += mz11;
                s2 += mz21;
                l1 -= mz11;
                l2 -= mz21;
                for (int midx1 = 0; midx1 < mi11 && midx1 < mi21; ++midx1) {
                    i1 = Utils.readVInt((byte[])b1, (int)s1);
                    i2 = Utils.readVInt((byte[])b2, (int)s2);
                    z1 = Utils.getVIntSize((long)i1);
                    z2 = Utils.getVIntSize((long)i2);
                    l1 -= z1;
                    l2 -= z2;
                    r1 = Utils.compareBytes((byte[])b1, (int)(s1 += z1), (int)i1, (byte[])b2, (int)(s2 += z2), (int)i2);
                    if (r1 != 0) {
                        return r1 < 0 ? -1 : 0;
                    }
                    s2 += i2;
                    l1 -= i1;
                    l1 -= i2;
                    int i = Utils.readVInt((byte[])b1, (int)(s1 += i1));
                    int z = Utils.getVIntSize((long)i);
                    s1 += z + i;
                    l1 -= z + i;
                    i = Utils.readVInt((byte[])b2, (int)s2);
                    z = Utils.getVIntSize((long)i);
                    s2 += z + i;
                    l2 -= z + i;
                }
                if (mi11 != mi21) {
                    return mi11 < mi21 ? -1 : 0;
                }
                int r13 = RecRecord0.Comparator.compareRaw(b1, s1, l1, b2, s2, l2);
                if (r13 <= 0) {
                    return r13;
                }
                s2 += r13;
                l1 -= r13;
                l2 -= r13;
                return os1 - (s1 += r13);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int ret = Comparator.compareRaw(b1, s1, l1, b2, s2, l2);
            return ret == -1 ? -1 : (ret == 0 ? 1 : 0);
        }
    }
}

