/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class TestTrackerDistributedCacheManager
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestTrackerDistributedCacheManager.class);
    protected String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestTrackerDistributedCacheManager.class.getSimpleName()).getAbsolutePath();
    protected File ROOT_MAPRED_LOCAL_DIR;
    protected int numLocalDirs = 6;
    private static final int TEST_FILE_SIZE = 4096;
    private static final int LOCAL_CACHE_LIMIT = 5120;
    private static final int LOCAL_CACHE_SUBDIR_LIMIT = 1;
    protected Configuration conf;
    protected Path firstCacheFile;
    protected Path firstCacheFilePublic;
    protected Path secondCacheFile;
    protected Path secondCacheFilePublic;
    protected Path firstCacheDirPublic;
    protected Path firstCacheDirPrivate;
    protected Path firstCacheFileInDirPublic;
    protected Path firstCacheFileInDirPrivate;
    private FileSystem fs;
    protected LocalDirAllocator localDirAllocator = new LocalDirAllocator("mapred.local.dir");
    protected TaskController taskController;
    public static final long CACHE_DELETE_PERIOD_MS = 100L;

    protected void setUp() throws IOException, InterruptedException {
        File TEST_ROOT = new File(this.TEST_ROOT_DIR);
        if (!TEST_ROOT.exists()) {
            TEST_ROOT.mkdirs();
        }
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.fs = FileSystem.get((Configuration)this.conf);
        TestTrackerDistributedCacheManager.assertTrue((String)("Test root directory " + TEST_ROOT + " and all of its " + "parent directories must have a+x permissions"), (boolean)TrackerDistributedCacheManager.ancestorsHaveExecutePermissions((FileSystem)this.fs, (Path)new Path(TEST_ROOT.toString())));
        this.ROOT_MAPRED_LOCAL_DIR = new File(this.TEST_ROOT_DIR, "mapred/local");
        this.ROOT_MAPRED_LOCAL_DIR.mkdirs();
        String[] localDirs = new String[this.numLocalDirs];
        for (int i = 0; i < this.numLocalDirs; ++i) {
            File localDir = new File(this.ROOT_MAPRED_LOCAL_DIR, "0_" + i);
            localDirs[i] = localDir.getPath();
            localDir.mkdir();
        }
        this.conf.setStrings("mapred.local.dir", localDirs);
        Class taskControllerClass = this.conf.getClass("mapred.task.tracker.task-controller", DefaultTaskController.class, TaskController.class);
        this.taskController = (TaskController)ReflectionUtils.newInstance((Class)taskControllerClass, (Configuration)this.conf);
        UtilsForTests.setupTC(this.taskController, this.localDirAllocator, this.conf.getStrings("mapred.local.dir"));
        this.firstCacheFile = new Path(this.TEST_ROOT_DIR, "firstcachefile");
        this.secondCacheFile = new Path(this.TEST_ROOT_DIR, "secondcachefile");
        this.firstCacheFilePublic = new Path(this.TEST_ROOT_DIR, "firstcachefileOne");
        this.secondCacheFilePublic = new Path(this.TEST_ROOT_DIR, "secondcachefileOne");
        TestTrackerDistributedCacheManager.createPublicTempFile(this.firstCacheFilePublic);
        TestTrackerDistributedCacheManager.createPublicTempFile(this.secondCacheFilePublic);
        TestTrackerDistributedCacheManager.createPrivateTempFile(this.firstCacheFile);
        TestTrackerDistributedCacheManager.createPrivateTempFile(this.secondCacheFile);
        this.firstCacheDirPublic = new Path(this.TEST_ROOT_DIR, "firstcachedirPublic");
        this.firstCacheDirPrivate = new Path(this.TEST_ROOT_DIR, "firstcachedirPrivate");
        this.firstCacheFileInDirPublic = new Path(this.firstCacheDirPublic, "firstcacheFileinDirPublic.txt");
        this.firstCacheFileInDirPrivate = new Path(this.firstCacheDirPrivate, "firstcacheFileinDirPrivate.txt");
        TestTrackerDistributedCacheManager.createPublicTempDir(this.firstCacheDirPublic);
        TestTrackerDistributedCacheManager.createPrivateTempDir(this.firstCacheDirPrivate);
        TestTrackerDistributedCacheManager.createPublicTempFile(this.firstCacheFileInDirPublic);
        TestTrackerDistributedCacheManager.createPrivateTempFile(this.firstCacheFileInDirPrivate);
    }

    protected void refreshConf(Configuration conf) throws IOException {
        this.taskController.setConf(conf);
        UtilsForTests.setupTC(this.taskController, this.localDirAllocator, conf.getStrings("mapred.local.dir"));
    }

    protected boolean canRun() {
        return true;
    }

    public void testManagerFlow() throws IOException, LoginException {
        if (!this.canRun()) {
            return;
        }
        Configuration subConf = new Configuration(this.conf);
        String userName = this.getJobOwnerName();
        subConf.set("user.name", userName);
        JobID jobid = new JobID("jt", 1);
        DistributedCache.addCacheFile((URI)this.firstCacheFile.toUri(), (Configuration)subConf);
        DistributedCache.addFileToClassPath((Path)this.secondCacheFile, (Configuration)subConf, (FileSystem)FileSystem.get((Configuration)subConf));
        TrackerDistributedCacheManager.determineTimestamps((Configuration)subConf);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)subConf);
        Path jobFile = new Path(this.TEST_ROOT_DIR, "job.xml");
        FileOutputStream os = new FileOutputStream(new File(jobFile.toString()));
        subConf.writeXml((OutputStream)os);
        os.close();
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        TaskDistributedCacheManager handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobid, subConf);
        TestTrackerDistributedCacheManager.assertNull(null, (Object)DistributedCache.getLocalCacheFiles((Configuration)subConf));
        File workDir = new File(new Path(this.TEST_ROOT_DIR, "workdir").toString());
        handle.setupCache(subConf, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        JobLocalizer.downloadPrivateCache((Configuration)subConf);
        Path[] localCacheFiles = DistributedCache.getLocalCacheFiles((Configuration)subConf);
        TestTrackerDistributedCacheManager.assertNotNull(null, (Object)localCacheFiles);
        TestTrackerDistributedCacheManager.assertEquals((int)2, (int)localCacheFiles.length);
        Path cachedFirstFile = localCacheFiles[0];
        Path cachedSecondFile = localCacheFiles[1];
        this.assertFileLengthEquals(this.firstCacheFile, cachedFirstFile);
        TestTrackerDistributedCacheManager.assertFalse((String)"Paths should be different.", (boolean)this.firstCacheFile.equals((Object)cachedFirstFile));
        TestTrackerDistributedCacheManager.assertEquals((int)1, (int)handle.getClassPaths().size());
        TestTrackerDistributedCacheManager.assertEquals((String)cachedSecondFile.toString(), (String)((String)handle.getClassPaths().get(0)));
        this.checkFilePermissions(localCacheFiles);
        handle.release();
        manager.purgeCache();
        TestTrackerDistributedCacheManager.assertFalse((boolean)this.pathToFile(cachedFirstFile).exists());
    }

    public void testReferenceCount() throws IOException, LoginException, URISyntaxException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        FakeTrackerDistributedCacheManager manager = new FakeTrackerDistributedCacheManager(this.conf);
        String userName = this.getJobOwnerName();
        File workDir = new File(new Path(this.TEST_ROOT_DIR, "workdir").toString());
        Job job1 = new Job(this.conf);
        Configuration conf1 = job1.getConfiguration();
        conf1.set("user.name", userName);
        DistributedCache.addCacheFile((URI)this.secondCacheFile.toUri(), (Configuration)conf1);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)conf1);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf1);
        JobID jobId = new JobID("jt", 1);
        TaskDistributedCacheManager handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobId, conf1);
        handle.setupCache(conf1, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        long[] sizes = JobLocalizer.downloadPrivateCache((Configuration)conf1);
        if (sizes != null) {
            manager.setArchiveSizes((org.apache.hadoop.mapreduce.JobID)jobId, sizes);
        }
        handle.release();
        for (TaskDistributedCacheManager.CacheFile c : handle.getCacheFiles()) {
            TestTrackerDistributedCacheManager.assertEquals((int)0, (int)manager.getReferenceCount(c.getStatus()));
            long filesize = FileUtil.getDU((File)new File(c.getStatus().localizedLoadPath.getParent().toString()));
            TestTrackerDistributedCacheManager.assertTrue((String)"filesize is not greater than 0", (filesize > 0L ? 1 : 0) != 0);
            TestTrackerDistributedCacheManager.assertEquals((long)filesize, (long)c.getStatus().size);
        }
        Job job2 = new Job(this.conf);
        Configuration conf2 = job2.getConfiguration();
        conf1.set("user.name", userName);
        DistributedCache.addCacheFile((URI)this.firstCacheDirPublic.toUri(), (Configuration)conf2);
        DistributedCache.addCacheFile((URI)this.firstCacheDirPrivate.toUri(), (Configuration)conf2);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)conf2);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf2);
        JobID job2Id = new JobID("jt", 2);
        handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)job2Id, conf2);
        handle.setupCache(conf2, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        long[] sizes2 = JobLocalizer.downloadPrivateCache((Configuration)conf2);
        for (int j = 0; j > sizes2.length; ++j) {
            LOG.info((Object)("size is: " + sizes2[j]));
        }
        if (sizes2 != null) {
            manager.setArchiveSizes((org.apache.hadoop.mapreduce.JobID)job2Id, sizes2);
        }
        handle.release();
        for (TaskDistributedCacheManager.CacheFile c : handle.getCacheFiles()) {
            TestTrackerDistributedCacheManager.assertEquals((int)0, (int)manager.getReferenceCount(c.getStatus()));
            long filesize = FileUtil.getDU((File)new File(c.getStatus().localizedLoadPath.getParent().toString()));
            TestTrackerDistributedCacheManager.assertTrue((String)"filesize is not greater than 0", (filesize > 0L ? 1 : 0) != 0);
            TestTrackerDistributedCacheManager.assertEquals((long)filesize, (long)c.getStatus().size);
        }
        Path thirdCacheFile = new Path(this.TEST_ROOT_DIR, "thirdcachefile");
        TestTrackerDistributedCacheManager.createPrivateTempFile(thirdCacheFile);
        Job job3 = new Job(this.conf);
        Configuration conf3 = job3.getConfiguration();
        conf3.set("user.name", userName);
        DistributedCache.addCacheFile((URI)this.firstCacheFilePublic.toUri(), (Configuration)conf3);
        DistributedCache.addCacheFile((URI)this.secondCacheFile.toUri(), (Configuration)conf3);
        DistributedCache.addCacheFile((URI)thirdCacheFile.toUri(), (Configuration)conf3);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)conf3);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf3);
        handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)new JobID("jt", 3), conf3);
        Exception th = null;
        try {
            handle.setupCache(conf3, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
            JobLocalizer.downloadPrivateCache((Configuration)conf3);
        }
        catch (IOException e) {
            th = e;
            LOG.info((Object)"Exception during setup", (Throwable)e);
        }
        TestTrackerDistributedCacheManager.assertNotNull((Object)th);
        TestTrackerDistributedCacheManager.assertTrue((boolean)th.getMessage().contains("fake fail"));
        handle.release();
        th = null;
        for (TaskDistributedCacheManager.CacheFile c : handle.getCacheFiles()) {
            try {
                int refcount = manager.getReferenceCount(c.getStatus());
                LOG.info((Object)("checking refcount " + c.uri + " of " + refcount));
                TestTrackerDistributedCacheManager.assertEquals((int)0, (int)refcount);
            }
            catch (NullPointerException ie) {
                th = ie;
                LOG.info((Object)("Exception getting reference count for " + c.uri), (Throwable)ie);
            }
        }
        TestTrackerDistributedCacheManager.assertNotNull((Object)th);
        this.fs.delete(thirdCacheFile, false);
    }

    public void testPublicPrivateCache() throws IOException, LoginException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        this.checkLocalizedPath(true);
        this.checkLocalizedPath(false);
    }

    public void testSameNameFileArchiveCache() throws IOException, InterruptedException {
        if (!this.canRun()) {
            return;
        }
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        String userName = this.getJobOwnerName();
        File workDir = new File(this.TEST_ROOT_DIR, "workdir");
        Path cacheFile = new Path(this.TEST_ROOT_DIR, "fileArchiveCacheFile");
        TestTrackerDistributedCacheManager.createPublicTempFile(cacheFile);
        Configuration conf1 = new Configuration(this.conf);
        conf1.set("user.name", userName);
        DistributedCache.addCacheFile((URI)cacheFile.toUri(), (Configuration)conf1);
        DistributedCache.addCacheArchive((URI)cacheFile.toUri(), (Configuration)conf1);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)conf1);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf1);
        this.dumpState(conf1);
        TaskDistributedCacheManager handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)new JobID("jt", 1), conf1);
        handle.setupCache(conf1, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        TaskDistributedCacheManager.CacheFile cFile = (TaskDistributedCacheManager.CacheFile)handle.getCacheFiles().get(0);
        TaskDistributedCacheManager.CacheFile cArchive = (TaskDistributedCacheManager.CacheFile)handle.getCacheFiles().get(1);
        String distCacheDir = TaskTracker.getPublicDistributedCacheDir();
        Path localizedPathForFile = manager.getLocalCache(cacheFile.toUri(), conf1, distCacheDir, this.fs.getFileStatus(cacheFile), false, cFile.timestamp, true, cFile);
        Path localizedPathForArchive = manager.getLocalCache(cacheFile.toUri(), conf1, distCacheDir, this.fs.getFileStatus(cacheFile), true, cArchive.timestamp, true, cArchive);
        TestTrackerDistributedCacheManager.assertNotSame((String)("File and Archive resolve to the same path: " + localizedPathForFile + ". Should differ."), (Object)localizedPathForFile, (Object)localizedPathForArchive);
    }

    private void appendStringArray(StringBuilder buffer, String[] data) {
        if (data != null && data.length != 0) {
            buffer.append(data[0]);
            for (int i = 1; i < data.length; ++i) {
                buffer.append(',');
                buffer.append(data[i]);
            }
        }
    }

    private void appendBooleanArray(StringBuilder buffer, boolean[] data) {
        if (data != null && data.length != 0) {
            buffer.append(data[0]);
            for (int i = 1; i < data.length; ++i) {
                buffer.append(',');
                buffer.append(data[i]);
            }
        }
    }

    private void appendLongArray(StringBuilder buffer, long[] data) {
        if (data != null && data.length != 0) {
            buffer.append(data[0]);
            for (int i = 1; i < data.length; ++i) {
                buffer.append(',');
                buffer.append(data[i]);
            }
        }
    }

    private void appendUriArray(StringBuilder buffer, URI[] data) {
        if (data != null && data.length != 0) {
            buffer.append(data[0]);
            for (int i = 1; i < data.length; ++i) {
                buffer.append(',');
                buffer.append(data[i]);
            }
        }
    }

    private void dumpState(Configuration conf1) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("\nFiles:");
        this.appendUriArray(buf, DistributedCache.getCacheFiles((Configuration)conf1));
        buf.append("\nArchives:");
        this.appendUriArray(buf, DistributedCache.getCacheArchives((Configuration)conf1));
        buf.append("\nFile Visible:");
        this.appendBooleanArray(buf, TrackerDistributedCacheManager.getFileVisibilities((Configuration)conf1));
        buf.append("\nArchive Visible:");
        this.appendBooleanArray(buf, TrackerDistributedCacheManager.getArchiveVisibilities((Configuration)conf1));
        buf.append("\nFile timestamps:");
        this.appendLongArray(buf, DistributedCache.getFileTimestamps((Configuration)conf1));
        buf.append("\nArchive timestamps:");
        this.appendLongArray(buf, DistributedCache.getArchiveTimestamps((Configuration)conf1));
        LOG.info((Object)("state = " + buf.toString()));
    }

    private void checkLocalizedPath(boolean visibility) throws IOException, LoginException, InterruptedException {
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        String userName = this.getJobOwnerName();
        File workDir = new File(this.TEST_ROOT_DIR, "workdir");
        Path cacheFile = new Path(this.TEST_ROOT_DIR, "fourthcachefile");
        if (visibility) {
            TestTrackerDistributedCacheManager.createPublicTempFile(cacheFile);
        } else {
            TestTrackerDistributedCacheManager.createPrivateTempFile(cacheFile);
        }
        Configuration conf1 = new Configuration(this.conf);
        conf1.set("user.name", userName);
        DistributedCache.addCacheFile((URI)cacheFile.toUri(), (Configuration)conf1);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)conf1);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf1);
        this.dumpState(conf1);
        TaskDistributedCacheManager handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)new JobID("jt", 1), conf1);
        handle.setupCache(conf1, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        JobLocalizer.downloadPrivateCache((Configuration)conf1);
        TaskDistributedCacheManager.CacheFile c = (TaskDistributedCacheManager.CacheFile)handle.getCacheFiles().get(0);
        String distCacheDir = visibility ? TaskTracker.getPublicDistributedCacheDir() : TaskTracker.getPrivateDistributedCacheDir((String)userName);
        Path localizedPath = manager.getLocalCache(cacheFile.toUri(), conf1, distCacheDir, this.fs.getFileStatus(cacheFile), false, c.timestamp, visibility, c);
        TestTrackerDistributedCacheManager.assertTrue((String)("Cache file didn't get localized in the expected directory. Expected localization to happen within " + this.ROOT_MAPRED_LOCAL_DIR + "/" + distCacheDir + ", but was localized at " + localizedPath), (boolean)localizedPath.toString().contains(distCacheDir));
        if (visibility) {
            this.checkPublicFilePermissions(new Path[]{localizedPath});
        } else {
            this.checkFilePermissions(new Path[]{localizedPath});
        }
    }

    protected void checkFilePermissions(Path[] localCacheFiles) throws IOException {
        for (Path p : localCacheFiles) {
            TestTrackerDistributedCacheManager.assertTrue((String)"Cache file is not executable!", (boolean)new File(p.toUri().getPath()).canExecute());
        }
    }

    private void checkPublicFilePermissions(Path[] localCacheFiles) throws IOException {
        TestTrackerDistributedCacheManager.checkPublicFilePermissions(this.fs, localCacheFiles);
    }

    public static void checkPublicFilePermissions(FileSystem fs, Path[] localCacheFiles) throws IOException {
        for (Path p : localCacheFiles) {
            FsPermission perm = fs.getFileStatus(p).getPermission();
            TestTrackerDistributedCacheManager.assertTrue((String)("cache file is not readable / executable by owner: perm=" + perm.getUserAction()), (boolean)perm.getUserAction().implies(FsAction.READ_EXECUTE));
            TestTrackerDistributedCacheManager.assertTrue((String)("cache file is not readable / executable by group: perm=" + perm.getGroupAction()), (boolean)perm.getGroupAction().implies(FsAction.READ_EXECUTE));
            TestTrackerDistributedCacheManager.assertTrue((String)("cache file is not readable / executable by others: perm=" + perm.getOtherAction()), (boolean)perm.getOtherAction().implies(FsAction.READ_EXECUTE));
        }
    }

    public static void checkPublicFileOwnership(FileSystem fs, Path[] localCacheFiles, String owner, String group) throws IOException {
        for (Path p : localCacheFiles) {
            TestTrackerDistributedCacheManager.assertEquals((String)owner, (String)fs.getFileStatus(p).getOwner());
            TestTrackerDistributedCacheManager.assertEquals((String)group, (String)fs.getFileStatus(p).getGroup());
        }
    }

    public void testRuntimeExceptionInCleanup() throws Exception {
        if (!this.canRun()) {
            return;
        }
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("mapred.local.dir", this.ROOT_MAPRED_LOCAL_DIR.toString());
        conf2.setLong("local.cache.size", 5120L);
        conf2.setLong("mapreduce.tasktracker.distributedcache.checkperiod", 0L);
        this.refreshConf(conf2);
        MyTrackerDistributedCacheManager manager = new MyTrackerDistributedCacheManager(conf2, this.taskController);
        manager.startCleanupThread();
        TestTrackerDistributedCacheManager.assertTrue((boolean)manager.done.await(200L, TimeUnit.MILLISECONDS));
        TestTrackerDistributedCacheManager.assertNotNull((Object)manager.caught);
        TestTrackerDistributedCacheManager.assertTrue((boolean)(manager.caught instanceof RuntimeException));
    }

    protected String getJobOwnerName() throws IOException {
        return UserGroupInformation.getLoginUser().getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLRUDeleteCache() throws Exception {
        if (!this.canRun()) {
            return;
        }
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("mapred.local.dir", this.ROOT_MAPRED_LOCAL_DIR.toString());
        conf2.setLong("local.cache.size", 21504L);
        conf2.setLong("mapreduce.tasktracker.local.cache.numberdirectories", 3L);
        conf2.setFloat("mapreduce.tasktracker.cache.local.keep.pct", 0.75f);
        conf2.setLong("mapreduce.tasktracker.distributedcache.checkperiod", 100L);
        this.refreshConf(conf2);
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(conf2, this.taskController);
        try {
            manager.startCleanupThread();
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf2);
            String userName = this.getJobOwnerName();
            conf2.set("user.name", userName);
            Path thirdCacheFile = new Path(this.TEST_ROOT_DIR, "thirdcachefile");
            Path fourthCacheFile = new Path(this.TEST_ROOT_DIR, "fourthcachefile");
            TestTrackerDistributedCacheManager.createTempFile(thirdCacheFile, 1);
            TestTrackerDistributedCacheManager.createTempFile(fourthCacheFile, 1);
            FileStatus stat = this.fs.getFileStatus(this.firstCacheFilePublic);
            TaskDistributedCacheManager.CacheFile cfile1 = new TaskDistributedCacheManager.CacheFile(this.firstCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            Path firstLocalCache = manager.getLocalCache(this.firstCacheFilePublic.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.firstCacheFilePublic), false, this.fs.getFileStatus(this.firstCacheFilePublic).getModificationTime(), true, cfile1);
            stat = this.fs.getFileStatus(this.secondCacheFilePublic);
            TaskDistributedCacheManager.CacheFile cfile2 = new TaskDistributedCacheManager.CacheFile(this.secondCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            Path secondLocalCache = manager.getLocalCache(this.secondCacheFilePublic.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.secondCacheFilePublic), false, this.fs.getFileStatus(this.secondCacheFilePublic).getModificationTime(), true, cfile2);
            stat = this.fs.getFileStatus(thirdCacheFile);
            TaskDistributedCacheManager.CacheFile cfile3 = new TaskDistributedCacheManager.CacheFile(thirdCacheFile.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            Path thirdLocalCache = manager.getLocalCache(thirdCacheFile.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(thirdCacheFile), false, this.fs.getFileStatus(thirdCacheFile).getModificationTime(), true, cfile3);
            manager.releaseCache(cfile3.getStatus());
            manager.releaseCache(cfile2.getStatus());
            manager.releaseCache(cfile1.getStatus());
            stat = this.fs.getFileStatus(fourthCacheFile);
            TaskDistributedCacheManager.CacheFile cfile4 = new TaskDistributedCacheManager.CacheFile(fourthCacheFile.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            Path fourthLocalCache = manager.getLocalCache(fourthCacheFile.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(fourthCacheFile), false, this.fs.getFileStatus(fourthCacheFile).getModificationTime(), true, cfile4);
            this.checkCacheDeletion((FileSystem)localfs, secondLocalCache, "DistributedCache failed deleting second cache LRU order");
            this.checkCacheDeletion((FileSystem)localfs, thirdLocalCache, "DistributedCache failed deleting third cache LRU order.");
            this.checkCacheNOTDeletion((FileSystem)localfs, firstLocalCache, "DistributedCache failed Deleted first cache LRU order.");
            this.checkCacheNOTDeletion((FileSystem)localfs, fourthCacheFile, "DistributedCache failed Deleted fourth cache LRU order.");
            new File(thirdCacheFile.toString()).delete();
            new File(fourthCacheFile.toString()).delete();
        }
        finally {
            manager.stopCleanupThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteCache() throws Exception {
        if (!this.canRun()) {
            return;
        }
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("mapred.local.dir", this.ROOT_MAPRED_LOCAL_DIR.toString());
        conf2.setLong("local.cache.size", 5120L);
        conf2.setLong("mapreduce.tasktracker.distributedcache.checkperiod", 100L);
        this.refreshConf(conf2);
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(conf2, this.taskController);
        manager.startCleanupThread();
        try {
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf2);
            long now = System.currentTimeMillis();
            String userName = this.getJobOwnerName();
            conf2.set("user.name", userName);
            FileStatus stat = this.fs.getFileStatus(this.firstCacheFilePublic);
            TaskDistributedCacheManager.CacheFile cfile1 = new TaskDistributedCacheManager.CacheFile(this.firstCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            Path firstLocalCache = manager.getLocalCache(this.firstCacheFilePublic.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.firstCacheFilePublic), false, this.fs.getFileStatus(this.firstCacheFilePublic).getModificationTime(), true, cfile1);
            manager.releaseCache(cfile1.getStatus());
            stat = this.fs.getFileStatus(this.secondCacheFilePublic);
            TaskDistributedCacheManager.CacheFile cfile2 = new TaskDistributedCacheManager.CacheFile(this.secondCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), true);
            TestTrackerDistributedCacheManager.assertTrue((String)"DistributedCache currently doesn't have cached file", (boolean)localfs.exists(firstLocalCache));
            Path secondLocalCache = manager.getLocalCache(this.secondCacheFilePublic.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.secondCacheFilePublic), false, this.fs.getFileStatus(this.secondCacheFilePublic).getModificationTime(), true, cfile2);
            this.checkCacheDeletion((FileSystem)localfs, firstLocalCache, "DistributedCache failed deleting old cache when the cache store is full");
            Path firstCursor = firstLocalCache;
            Path secondCursor = secondLocalCache;
            while (!firstCursor.equals((Object)secondCursor)) {
                System.err.println("cursors: " + firstCursor);
                System.err.println(" and " + secondCursor);
                firstCursor = firstCursor.getParent();
                secondCursor = secondCursor.getParent();
            }
            System.err.println("The final cursor is " + firstCursor);
            System.err.println("That directory ends up with " + localfs.listStatus(firstCursor).length + " subdirectories");
            Path cachesBase = firstCursor;
            TestTrackerDistributedCacheManager.assertFalse((String)"DistributedCache did not delete the gensym'ed distcache directory names when it deleted the files they contained because they collectively exceeded the size limit.", (localfs.listStatus(cachesBase).length > 1 ? 1 : 0) != 0);
            conf2.setLong("local.cache.size", 51200L);
            conf2.setLong("mapreduce.tasktracker.local.cache.numberdirectories", 1L);
            manager.stopCleanupThread();
            manager = new TrackerDistributedCacheManager(conf2, this.taskController);
            manager.startCleanupThread();
            Path thirdCacheFile = new Path(this.TEST_ROOT_DIR, "thirdcachefile");
            Path fourthCacheFile = new Path(this.TEST_ROOT_DIR, "fourthcachefile");
            TestTrackerDistributedCacheManager.createPrivateTempFile(thirdCacheFile);
            TestTrackerDistributedCacheManager.createPrivateTempFile(fourthCacheFile);
            DistributedCache.setCacheFiles((URI[])new URI[]{thirdCacheFile.toUri()}, (Configuration)conf2);
            TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf2);
            TrackerDistributedCacheManager.determineTimestamps((Configuration)conf2);
            stat = this.fs.getFileStatus(thirdCacheFile);
            TaskDistributedCacheManager.CacheFile cfile3 = new TaskDistributedCacheManager.CacheFile(thirdCacheFile.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, false, stat.getModificationTime(), true);
            Path thirdLocalCache = manager.getLocalCache(thirdCacheFile.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(thirdCacheFile), false, this.fs.getFileStatus(thirdCacheFile).getModificationTime(), false, cfile3);
            DistributedCache.setLocalFiles((Configuration)conf2, (String)thirdLocalCache.toString());
            JobLocalizer.downloadPrivateCache((Configuration)conf2);
            manager.releaseCache(cfile3.getStatus());
            stat = this.fs.getFileStatus(fourthCacheFile);
            TaskDistributedCacheManager.CacheFile cfile4 = new TaskDistributedCacheManager.CacheFile(fourthCacheFile.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, false, stat.getModificationTime(), true);
            TestTrackerDistributedCacheManager.assertTrue((String)"DistributedCache currently doesn't have cached file", (boolean)localfs.exists(thirdLocalCache));
            DistributedCache.setCacheFiles((URI[])new URI[]{fourthCacheFile.toUri()}, (Configuration)conf2);
            DistributedCache.setLocalFiles((Configuration)conf2, (String)thirdCacheFile.toUri().toString());
            TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)conf2);
            TrackerDistributedCacheManager.determineTimestamps((Configuration)conf2);
            Path fourthLocalCache = manager.getLocalCache(fourthCacheFile.toUri(), conf2, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(fourthCacheFile), false, this.fs.getFileStatus(fourthCacheFile).getModificationTime(), false, cfile4);
            this.checkCacheDeletion((FileSystem)localfs, thirdLocalCache, "DistributedCache failed deleting old cache when the cache exceeds the number of sub directories limit.");
            TestTrackerDistributedCacheManager.assertFalse((String)"DistributedCache did not delete the gensym'ed distcache directory names when it deleted the files they contained because there were too many.", (localfs.listStatus(cachesBase).length > 1 ? 1 : 0) != 0);
            new File(thirdCacheFile.toString()).delete();
            new File(fourthCacheFile.toString()).delete();
        }
        finally {
            manager.stopCleanupThread();
        }
    }

    private void checkCacheNOTDeletion(FileSystem fs, Path cache, String msg) throws Exception {
        TimeUnit.MILLISECONDS.sleep(300L);
        TestTrackerDistributedCacheManager.assertTrue((String)msg, (boolean)fs.exists(cache));
    }

    private void checkCacheDeletion(FileSystem fs, Path cache, String msg) throws Exception {
        boolean cacheExists = true;
        for (int i = 0; i < 300; ++i) {
            if (!fs.exists(cache)) {
                cacheExists = false;
                break;
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        TestTrackerDistributedCacheManager.assertFalse((String)msg, (boolean)cacheExists);
    }

    public void testFileSystemOtherThanDefault() throws Exception {
        if (!this.canRun()) {
            return;
        }
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        this.conf.set("fs.fakefile.impl", this.conf.get("fs.file.impl"));
        String userName = this.getJobOwnerName();
        this.conf.set("user.name", userName);
        Path fileToCache = new Path("fakefile:///" + this.firstCacheFile.toUri().getPath());
        TaskDistributedCacheManager.CacheFile file = new TaskDistributedCacheManager.CacheFile(fileToCache.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, false, 0L, false);
        Path result = manager.getLocalCache(fileToCache.toUri(), this.conf, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.firstCacheFile), false, System.currentTimeMillis(), false, file);
        TestTrackerDistributedCacheManager.assertNotNull((String)"DistributedCache cached file on non-default filesystem.", (Object)result);
    }

    static void createTempFile(Path p) throws IOException {
        TestTrackerDistributedCacheManager.createTempFile(p, 4096);
    }

    static void createTempDir(Path p) throws IOException {
        File dir = new File(p.toString());
        dir.mkdirs();
        FileSystem.LOG.info((Object)("created temp directory: " + p));
    }

    static void createTempFile(Path p, int size) throws IOException {
        File f = new File(p.toString());
        FileOutputStream os = new FileOutputStream(f);
        byte[] toWrite = new byte[size];
        new Random().nextBytes(toWrite);
        os.write(toWrite);
        os.close();
        FileSystem.LOG.info((Object)("created: " + p + ", size=" + size));
    }

    static void createPublicTempFile(Path p) throws IOException, InterruptedException {
        TestTrackerDistributedCacheManager.createTempFile(p);
        FileUtil.chmod((String)p.toString(), (String)"0777", (boolean)true);
    }

    static void createPrivateTempFile(Path p) throws IOException, InterruptedException {
        TestTrackerDistributedCacheManager.createTempFile(p);
        FileUtil.chmod((String)p.toString(), (String)"0770", (boolean)true);
    }

    static void createPublicTempDir(Path p) throws IOException, InterruptedException {
        TestTrackerDistributedCacheManager.createTempDir(p);
        FileUtil.chmod((String)p.toString(), (String)"0777", (boolean)true);
    }

    static void createPrivateTempDir(Path p) throws IOException, InterruptedException {
        TestTrackerDistributedCacheManager.createTempDir(p);
        FileUtil.chmod((String)p.toString(), (String)"0770", (boolean)true);
    }

    protected void tearDown() throws IOException {
        new File(this.firstCacheFile.toString()).delete();
        new File(this.secondCacheFile.toString()).delete();
        new File(this.firstCacheFilePublic.toString()).delete();
        new File(this.secondCacheFilePublic.toString()).delete();
        new File(this.firstCacheFileInDirPublic.toString()).delete();
        new File(this.firstCacheFileInDirPrivate.toString()).delete();
        new File(this.firstCacheDirPrivate.toString()).delete();
        new File(this.firstCacheDirPublic.toString()).delete();
        FileUtil.fullyDelete((File)new File(this.TEST_ROOT_DIR));
    }

    protected void assertFileLengthEquals(Path a, Path b) throws FileNotFoundException {
        TestTrackerDistributedCacheManager.assertEquals((String)"File sizes mismatch.", (long)this.pathToFile(a).length(), (long)this.pathToFile(b).length());
    }

    protected File pathToFile(Path p) {
        return new File(p.toString());
    }

    public void testFreshness() throws Exception {
        if (!this.canRun()) {
            return;
        }
        Configuration myConf = new Configuration(this.conf);
        myConf.set("fs.default.name", "refresh:///");
        myConf.setClass("fs.refresh.impl", FakeFileSystem.class, FileSystem.class);
        String userName = this.getJobOwnerName();
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(myConf, this.taskController);
        Configuration subConf = new Configuration(myConf);
        subConf.set("user.name", userName);
        DistributedCache.addCacheFile((URI)this.firstCacheFile.toUri(), (Configuration)subConf);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)subConf);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)subConf);
        TaskDistributedCacheManager handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)new JobID("jt", 1), subConf);
        TestTrackerDistributedCacheManager.assertNull(null, (Object)DistributedCache.getLocalCacheFiles((Configuration)subConf));
        File workDir = new File(new Path(this.TEST_ROOT_DIR, "workdir").toString());
        handle.setupCache(subConf, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        Path[] localCacheFiles = DistributedCache.getLocalCacheFiles((Configuration)subConf);
        TestTrackerDistributedCacheManager.assertNotNull(null, (Object)localCacheFiles);
        TestTrackerDistributedCacheManager.assertEquals((int)1, (int)localCacheFiles.length);
        Path cachedFirstFile = localCacheFiles[0];
        this.assertFileLengthEquals(this.firstCacheFile, cachedFirstFile);
        TestTrackerDistributedCacheManager.assertFalse((String)"Paths should be different.", (boolean)this.firstCacheFile.equals((Object)cachedFirstFile));
        handle.release();
        FileSystem fs = FileSystem.get((Configuration)myConf);
        ((FakeFileSystem)fs).advanceClock(1L);
        IOException th = null;
        try {
            handle.setupCache(subConf, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        }
        catch (IOException ie) {
            th = ie;
        }
        TestTrackerDistributedCacheManager.assertNotNull((String)"Throwable is null", (Object)th);
        TestTrackerDistributedCacheManager.assertTrue((String)"Exception message does not match", (boolean)th.getMessage().contains("has changed on HDFS since job started"));
        handle.release();
        Configuration subConf2 = new Configuration(myConf);
        subConf2.set("user.name", userName);
        DistributedCache.addCacheFile((URI)this.firstCacheFile.toUri(), (Configuration)subConf2);
        TrackerDistributedCacheManager.determineTimestamps((Configuration)subConf2);
        TrackerDistributedCacheManager.determineCacheVisibilities((Configuration)subConf2);
        handle = manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)new JobID("jt", 2), subConf2);
        handle.setupCache(subConf2, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir((String)userName));
        Path[] localCacheFiles2 = DistributedCache.getLocalCacheFiles((Configuration)subConf2);
        TestTrackerDistributedCacheManager.assertNotNull(null, (Object)localCacheFiles2);
        TestTrackerDistributedCacheManager.assertEquals((int)1, (int)localCacheFiles2.length);
        Path cachedFirstFile2 = localCacheFiles2[0];
        this.assertFileLengthEquals(this.firstCacheFile, cachedFirstFile2);
        TestTrackerDistributedCacheManager.assertFalse((String)"Paths should be different.", (boolean)this.firstCacheFile.equals((Object)cachedFirstFile2));
        TestTrackerDistributedCacheManager.assertFalse((String)"two jobs with different timestamps did not localize in different paths", (boolean)cachedFirstFile.equals((Object)cachedFirstFile2));
        handle.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomPermissions() throws Exception {
        if (!this.canRun()) {
            return;
        }
        String userName = this.getJobOwnerName();
        this.conf.set("user.name", userName);
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)this.conf);
        long now = System.currentTimeMillis();
        Path[] localCache = new Path[2];
        FileStatus stat = this.fs.getFileStatus(this.firstCacheFile);
        TaskDistributedCacheManager.CacheFile file = new TaskDistributedCacheManager.CacheFile(this.firstCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), false);
        localCache[0] = manager.getLocalCache(this.firstCacheFilePublic.toUri(), this.conf, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.firstCacheFilePublic), false, this.fs.getFileStatus(this.firstCacheFilePublic).getModificationTime(), true, file);
        FsPermission myPermission = new FsPermission(384);
        Path myFile = new Path(localCache[0].getParent(), "myfile.txt");
        if (FileSystem.create((FileSystem)localfs, (Path)myFile, (FsPermission)myPermission) == null) {
            throw new IOException("Could not create " + myFile);
        }
        try {
            stat = this.fs.getFileStatus(this.secondCacheFilePublic);
            file = new TaskDistributedCacheManager.CacheFile(this.secondCacheFilePublic.toUri(), TaskDistributedCacheManager.CacheFile.FileType.REGULAR, true, stat.getModificationTime(), false);
            localCache[1] = manager.getLocalCache(this.secondCacheFilePublic.toUri(), this.conf, TaskTracker.getPrivateDistributedCacheDir((String)userName), this.fs.getFileStatus(this.secondCacheFilePublic), false, this.fs.getFileStatus(this.secondCacheFilePublic).getModificationTime(), true, file);
            stat = localfs.getFileStatus(myFile);
            TestTrackerDistributedCacheManager.assertTrue((boolean)stat.getPermission().equals((Object)myPermission));
            this.checkFilePermissions(localCache);
        }
        finally {
            localfs.delete(myFile, false);
        }
    }

    public void testRemoveTaskDistributedCacheManager() throws Exception {
        if (!this.canRun()) {
            return;
        }
        TrackerDistributedCacheManager manager = new TrackerDistributedCacheManager(this.conf, this.taskController);
        JobID jobId = new JobID("jobtracker", 1);
        manager.newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobId, this.conf);
        TaskDistributedCacheManager taskDistributedCacheManager = manager.getTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobId);
        TestTrackerDistributedCacheManager.assertNotNull((Object)taskDistributedCacheManager);
        manager.removeTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobId);
        taskDistributedCacheManager = manager.getTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)jobId);
        TestTrackerDistributedCacheManager.assertNull((Object)taskDistributedCacheManager);
    }

    public static class FakeFileSystem
    extends RawLocalFileSystem {
        private long increment = 0L;

        public FileStatus getFileStatus(Path p) throws IOException {
            File f = this.pathToFile(p);
            return new FileStatus(f.length(), f.isDirectory(), 1, 128L, f.lastModified() + this.increment, this.makeQualified(new Path(f.getPath())));
        }

        void advanceClock(long millis) {
            this.increment += millis;
        }
    }

    public static class MyTrackerDistributedCacheManager
    extends TrackerDistributedCacheManager {
        public Throwable caught = null;
        public CountDownLatch done = new CountDownLatch(1);

        public MyTrackerDistributedCacheManager(Configuration conf, TaskController controller) throws IOException {
            super(conf, controller);
            this.baseDirManager = new TrackerDistributedCacheManager.BaseDirManager(){

                void checkAndCleanup() throws IOException {
                    throw new RuntimeException("This is a test!!!!");
                }
            };
            this.cleanupThread = new TestCleanupThread(conf);
        }

        class TestCleanupThread
        extends TrackerDistributedCacheManager.CleanupThread {
            public TestCleanupThread(Configuration conf) {
                super((TrackerDistributedCacheManager)MyTrackerDistributedCacheManager.this, conf);
            }

            protected void exitTaskTracker(Throwable t) {
                MyTrackerDistributedCacheManager.this.caught = t;
                this.stopRunning();
                MyTrackerDistributedCacheManager.this.done.countDown();
            }
        }
    }

    public class FakeTrackerDistributedCacheManager
    extends TrackerDistributedCacheManager {
        public FakeTrackerDistributedCacheManager(Configuration conf) throws IOException {
            super(conf, TestTrackerDistributedCacheManager.this.taskController);
        }

        Path localizePublicCacheObject(Configuration conf, URI cache, long confFileStamp, TrackerDistributedCacheManager.CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive) throws IOException {
            if (cache.equals(TestTrackerDistributedCacheManager.this.firstCacheFilePublic.toUri())) {
                throw new IOException("fake fail");
            }
            return super.localizePublicCacheObject(conf, cache, confFileStamp, cacheStatus, fileStatus, isArchive);
        }
    }
}

