/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;

public class TestLocalDirAllocator
extends TestCase {
    private static final Configuration conf = new Configuration();
    private static final String BUFFER_DIR_ROOT = "build/test/temp";
    private static final Path BUFFER_PATH_ROOT = new Path("build/test/temp");
    private static final File BUFFER_ROOT = new File("build/test/temp");
    private static final String[] BUFFER_DIR = new String[]{"build/test/temp/tmp0", "build/test/temp/tmp1", "build/test/temp/tmp2", "build/test/temp/tmp3", "build/test/temp/tmp4", "build/test/temp/tmp5", "build/test/temp/tmp6"};
    private static final Path[] BUFFER_PATH = new Path[]{new Path(BUFFER_DIR[0]), new Path(BUFFER_DIR[1]), new Path(BUFFER_DIR[2]), new Path(BUFFER_DIR[3]), new Path(BUFFER_DIR[4]), new Path(BUFFER_DIR[5]), new Path(BUFFER_DIR[6])};
    private static final String CONTEXT = "dfs.client.buffer.dir";
    private static final String FILENAME = "block";
    private static final LocalDirAllocator dirAllocator = new LocalDirAllocator("dfs.client.buffer.dir");
    static LocalFileSystem localFs;
    private static final boolean isWindows;
    static final int SMALL_FILE_SIZE = 100;
    static final int TRIALS = 100;

    private static void rmBufferDirs() throws IOException {
        TestLocalDirAllocator.assertTrue((!localFs.exists(BUFFER_PATH_ROOT) || localFs.delete(BUFFER_PATH_ROOT) ? 1 : 0) != 0);
    }

    private void validateTempDirCreation(int i) throws IOException {
        File result = this.createTempFile(100L);
        TestLocalDirAllocator.assertTrue((String)("Checking for " + BUFFER_DIR[i] + " in " + result + " - FAILED!"), (boolean)result.getPath().startsWith(new File(BUFFER_DIR[i], FILENAME).getPath()));
    }

    private File createTempFile() throws IOException {
        File result = dirAllocator.createTmpFileForWrite(FILENAME, -1L, conf);
        result.delete();
        return result;
    }

    private File createTempFile(long size) throws IOException {
        File result = dirAllocator.createTmpFileForWrite(FILENAME, size, conf);
        result.delete();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test0() throws Exception {
        if (isWindows) {
            return;
        }
        try {
            conf.set(CONTEXT, BUFFER_DIR[0] + "," + BUFFER_DIR[1]);
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[1]));
            BUFFER_ROOT.setReadOnly();
            this.validateTempDirCreation(1);
            this.validateTempDirCreation(1);
        }
        catch (Throwable throwable) {
            Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
            TestLocalDirAllocator.rmBufferDirs();
            throw throwable;
        }
        Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
        TestLocalDirAllocator.rmBufferDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() throws Exception {
        if (isWindows) {
            return;
        }
        try {
            conf.set(CONTEXT, BUFFER_DIR[1] + "," + BUFFER_DIR[2]);
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[2]));
            BUFFER_ROOT.setReadOnly();
            this.validateTempDirCreation(2);
            this.validateTempDirCreation(2);
        }
        catch (Throwable throwable) {
            Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
            TestLocalDirAllocator.rmBufferDirs();
            throw throwable;
        }
        Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
        TestLocalDirAllocator.rmBufferDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws Exception {
        if (isWindows) {
            return;
        }
        try {
            conf.set(CONTEXT, BUFFER_DIR[2] + "," + BUFFER_DIR[3]);
            this.createTempFile(100L);
            int firstDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 2 : 3;
            int secondDirIdx = firstDirIdx == 2 ? 3 : 2;
            this.validateTempDirCreation(firstDirIdx);
            this.validateTempDirCreation(secondDirIdx);
            this.validateTempDirCreation(firstDirIdx);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test3() throws Exception {
        if (isWindows) {
            return;
        }
        try {
            conf.set(CONTEXT, BUFFER_DIR[3] + "," + BUFFER_DIR[4]);
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[3]));
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[4]));
            this.createTempFile(100L);
            int nextDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 3 : 4;
            this.validateTempDirCreation(nextDirIdx);
            new File(BUFFER_DIR[4]).setReadOnly();
            this.validateTempDirCreation(3);
            this.validateTempDirCreation(3);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test4() throws Exception {
        if (isWindows) {
            return;
        }
        try {
            conf.set(CONTEXT, BUFFER_DIR[5] + "," + BUFFER_DIR[6]);
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[5]));
            TestLocalDirAllocator.assertTrue((boolean)localFs.mkdirs(BUFFER_PATH[6]));
            int inDir5 = 0;
            int inDir6 = 0;
            for (int i = 0; i < 100; ++i) {
                File result = this.createTempFile();
                if (result.getPath().startsWith(new File(BUFFER_DIR[5], FILENAME).getPath())) {
                    ++inDir5;
                } else if (result.getPath().startsWith(new File(BUFFER_DIR[6], FILENAME).getPath())) {
                    ++inDir6;
                }
                result.delete();
            }
            TestLocalDirAllocator.assertTrue((inDir5 + inDir6 == 100 ? 1 : 0) != 0);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    static {
        isWindows = System.getProperty("os.name").startsWith("Windows");
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
            TestLocalDirAllocator.rmBufferDirs();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

