/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestFileCreation {
    static final String DIR = "/" + TestFileCreation.class.getSimpleName() + "/";
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int numBlocks = 2;
    static final int fileSize = 16385;
    boolean simulatedStorage;

    public TestFileCreation() {
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.simulatedStorage = false;
    }

    static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        System.out.println("createFile: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        return stm;
    }

    static void writeFile(FSDataOutputStream stm) throws IOException {
        TestFileCreation.writeFile(stm, 16385);
    }

    static void writeFile(FSDataOutputStream stm, int size) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(3735928559L, size);
        stm.write(buffer, 0, size);
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        byte[] expected;
        boolean done = false;
        block2: while (!done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 16385L);
            if (locations.length < 2) {
                done = false;
                continue;
            }
            for (int idx = 0; idx < locations.length; ++idx) {
                if (locations[idx].getHosts().length >= repl) continue;
                done = false;
                continue block2;
            }
        }
        FSDataInputStream stm = fileSys.open(name);
        if (this.simulatedStorage) {
            expected = new byte[16384];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = 9;
            }
        } else {
            expected = AppendTestUtil.randomBytes(3735928559L, 16384);
        }
        byte[] actual = new byte[16384];
        stm.readFully(0L, actual);
        stm.close();
        TestFileCreation.checkData(actual, 0, expected, "Read 1");
    }

    private static void checkData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)expected[from + idx], (long)actual[idx]);
            actual[idx] = 0;
        }
    }

    static void checkFullFile(FileSystem fs, Path name) throws IOException {
        FileStatus stat = fs.getFileStatus(name);
        BlockLocation[] locations = fs.getFileBlockLocations(stat, 0L, 16385L);
        for (int idx = 0; idx < locations.length; ++idx) {
            String[] hosts = locations[idx].getNames();
            for (int i = 0; i < hosts.length; ++i) {
                System.out.print(hosts[i] + " ");
            }
            System.out.println(" off " + locations[idx].getOffset() + " len " + locations[idx].getLength());
        }
        byte[] expected = AppendTestUtil.randomBytes(3735928559L, 16385);
        FSDataInputStream stm = fs.open(name);
        byte[] actual = new byte[16385];
        stm.readFully(0L, actual);
        TestFileCreation.checkData(actual, 0, expected, "Read 2");
        stm.close();
    }

    @Test
    public void testFileCreation() throws IOException {
        this.checkFileCreation(null, null);
    }

    @Test
    public void testFileCreationByHostname() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        this.checkFileCreation("localhost", null);
    }

    @Test
    public void testFileCreationSetLocalInterface() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        this.checkFileCreation(null, "lo");
        try {
            this.checkFileCreation(null, "bogus-interface");
            Assert.fail((String)"Able to specify a bogus interface");
        }
        catch (UnknownHostException e) {
            Assert.assertEquals((Object)"Unknown interface bogus-interface", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFileCreation(String hostname, String netIf) throws IOException {
        Configuration conf = new Configuration();
        if (hostname != null) {
            conf.setBoolean("dfs.client.use.datanode.hostname", true);
            conf.set("slave.host.name", hostname);
        }
        if (netIf != null) {
            conf.set("dfs.client.local.interfaces", netIf);
        }
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            block9: {
                Path path = new Path("/");
                System.out.println("Path : \"" + path.toString() + "\"");
                System.out.println(fs.getFileStatus(path).isDir());
                Assert.assertTrue((String)"/ should be a directory", (fs.getFileStatus(path).isDir() ? 1 : 0) != 0);
                Path dir1 = new Path("/test_dir");
                fs.mkdirs(dir1);
                System.out.println("createFile: Creating " + dir1.getName() + " for overwrite of existing directory.");
                try {
                    fs.create(dir1, true);
                    fs.close();
                    Assert.assertTrue((String)"Did not prevent directory from being overwritten.", (boolean)false);
                }
                catch (IOException ie) {
                    if (ie.getMessage().contains("already exists as a directory.")) break block9;
                    throw ie;
                }
            }
            Path file1 = new Path("filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            Assert.assertTrue((String)(file1 + " should be a file"), (!fs.getFileStatus(file1).isDir() ? 1 : 0) != 0);
            System.out.println("Path : \"" + file1 + "\"");
            TestFileCreation.writeFile(stm);
            this.checkFile(fs, file1, 1);
            long len = fs.getFileStatus(file1).getLen();
            Assert.assertTrue((String)(file1 + " should be of size " + 16384 + " but found to be of size " + len), (len == 16384L ? 1 : 0) != 0);
            stm.close();
            len = fs.getFileStatus(file1).getLen();
            Assert.assertTrue((String)(file1 + " should be of size " + 16385 + " but found to be of size " + len), (len == 16385L ? 1 : 0) != 0);
            if (this.simulatedStorage) {
                DataNode dn = cluster.getDataNodes().get(0);
                Assert.assertEquals((long)16385L, (long)dn.getFSDataset().getDfsUsed());
                Assert.assertEquals((long)0x1FFFFFFBFFFL, (long)dn.getFSDataset().getRemaining());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOnExit() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        try {
            Path file1 = new Path("filestatus.dat");
            Path file2 = new Path("filestatus2.dat");
            Path file3 = new Path("filestatus3.dat");
            FSDataOutputStream stm1 = TestFileCreation.createFile(fs, file1, 1);
            FSDataOutputStream stm2 = TestFileCreation.createFile(fs, file2, 1);
            FSDataOutputStream stm3 = TestFileCreation.createFile((FileSystem)localfs, file3, 1);
            System.out.println("DeleteOnExit: Created files.");
            TestFileCreation.writeFile(stm1);
            TestFileCreation.writeFile(stm3);
            stm1.close();
            stm2.close();
            stm3.close();
            fs.deleteOnExit(file1);
            fs.deleteOnExit(file2);
            localfs.deleteOnExit(file3);
            fs.close();
            localfs.close();
            fs = null;
            localfs = null;
            fs = cluster.getFileSystem();
            localfs = FileSystem.getLocal((Configuration)conf);
            Assert.assertTrue((String)(file1 + " still exists inspite of deletOnExit set."), (!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((String)(file2 + " still exists inspite of deletOnExit set."), (!fs.exists(file2) ? 1 : 0) != 0);
            Assert.assertTrue((String)(file3 + " still exists inspite of deletOnExit set."), (!localfs.exists(file3) ? 1 : 0) != 0);
            System.out.println("DeleteOnExit successful.");
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            IOUtils.closeStream((Closeable)localfs);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationNonRecursive() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        Path path = new Path("/" + System.currentTimeMillis() + "-testFileCreationNonRecursive");
        FSDataOutputStream out = null;
        try {
            IOException expectedException = null;
            String nonExistDir = "/non-exist-" + System.currentTimeMillis();
            fs.delete(new Path(nonExistDir), true);
            out = TestFileCreation.createNonRecursive(fs, path, 1, false);
            out.close();
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, new Path(path, "Create"), 1, false);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Create a file when parent directory exists as a file should throw FileAlreadyExistsException ", (expectedException != null && expectedException instanceof FileAlreadyExistsException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path2 = new Path(nonExistDir + "/testCreateNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, path2, 1, false);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Create a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
            out = TestFileCreation.createNonRecursive(fs, path, 1, true);
            out.close();
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, new Path(path, "Overwrite"), 1, true);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Overwrite a file when parent directory exists as a file should throw FileAlreadyExistsException ", (expectedException != null && expectedException instanceof FileAlreadyExistsException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path3 = new Path(nonExistDir + "/testOverwriteNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, path3, 1, true);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Overwrite a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    static FSDataOutputStream createNonRecursive(FileSystem fs, Path name, int repl, boolean overwrite) throws IOException {
        System.out.println("createNonRecursive: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = ((DistributedFileSystem)fs).createNonRecursive(name, FsPermission.getDefault(), overwrite, fs.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L, null);
        return stm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationError1() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, conf);
        try {
            DatanodeInfo[] info;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            Assert.assertTrue((String)(file1 + " should be a file"), (!fs.getFileStatus(file1).isDir() ? 1 : 0) != 0);
            System.out.println("Path : \"" + file1 + "\"");
            cluster.shutdownDataNodes();
            while ((info = client.datanodeReport(FSConstants.DatanodeReportType.LIVE)).length != 0) {
                System.out.println("testFileCreationError1: waiting for datanode  to die.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            try {
                stm.write(buffer);
                stm.close();
            }
            catch (Exception e) {
                System.out.println("Encountered expected exception");
            }
            LocatedBlocks locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)"Error blocks were not cleaned up", (locations.locatedBlockCount() == 0 ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationError2() throws IOException {
        long leasePeriod = 1000L;
        System.out.println("testFileCreationError2 start");
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path file1 = new Path("/filestatus.dat");
            TestFileCreation.createFile((FileSystem)dfs, file1, 1);
            System.out.println("testFileCreationError2: Created file filestatus.dat with one replicas.");
            LocatedBlocks locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: The file has " + locations.locatedBlockCount() + " blocks.");
            LocatedBlock location = client.namenode.addBlock(file1.toString(), client.clientName);
            System.out.println("testFileCreationError2: Added block " + location.getBlock());
            locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            int count = locations.locatedBlockCount();
            System.out.println("testFileCreationError2: The file now has " + count + " blocks.");
            cluster.setLeasePeriod(leasePeriod, leasePeriod);
            try {
                Thread.sleep(5L * leasePeriod);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: locations = " + locations.locatedBlockCount());
            Assert.assertEquals((long)0L, (long)locations.locatedBlockCount());
            System.out.println("testFileCreationError2 successful");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xxxtestFileCreationNamenodeRestart() throws IOException {
        Configuration conf = new Configuration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            int nnport = cluster.getNameNodePort();
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file1);
            int remainingPiece = 4096;
            int blocksMinusPiece = 16384 - remainingPiece;
            TestFileCreation.writeFile(stm, blocksMinusPiece);
            stm.sync();
            int actualRepl = ((DFSClient.DFSOutputStream)stm.getWrappedStream()).getNumCurrentReplicas();
            Assert.assertTrue((String)(file1 + " should be replicated to 1 datanodes, not " + actualRepl), (actualRepl == 1 ? 1 : 0) != 0);
            TestFileCreation.writeFile(stm, remainingPiece);
            stm.sync();
            Path fileRenamed = new Path("/filestatusRenamed.dat");
            fs.rename(file1, fileRenamed);
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file1 + " to " + fileRenamed);
            file1 = fileRenamed;
            Path file2 = new Path("/filestatus2.dat");
            FSDataOutputStream stm2 = TestFileCreation.createFile(fs, file2, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file2);
            Path file3 = new Path("/user/home/fullpath.dat");
            FSDataOutputStream stm3 = TestFileCreation.createFile(fs, file3, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file3);
            Path file4 = new Path("/user/home/fullpath4.dat");
            FSDataOutputStream stm4 = TestFileCreation.createFile(fs, file4, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file4);
            fs.mkdirs(new Path("/bin"));
            fs.rename(new Path("/user/home"), new Path("/bin"));
            Path file3new = new Path("/bin/home/fullpath.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file3 + " to " + file3new);
            Path file4new = new Path("/bin/home/fullpath4.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file4 + " to " + file4new);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster(nnport, conf, 1, false, true, null, null, null);
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster(nnport, conf, 1, false, true, null, null, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSClient.DFSOutputStream dfstream = (DFSClient.DFSOutputStream)stm.getWrappedStream();
            dfstream.setTestFilename(file1.toString());
            dfstream = (DFSClient.DFSOutputStream)stm3.getWrappedStream();
            dfstream.setTestFilename(file3new.toString());
            dfstream = (DFSClient.DFSOutputStream)stm4.getWrappedStream();
            dfstream.setTestFilename(file4new.toString());
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            stm.write(buffer);
            stm.close();
            stm2.write(buffer);
            stm2.close();
            stm3.close();
            stm4.close();
            DFSClient client = ((DistributedFileSystem)fs).dfs;
            LocatedBlocks locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)("Error blocks were not cleaned up for file " + file1), (locations.locatedBlockCount() == 3 ? 1 : 0) != 0);
            locations = client.namenode.getBlockLocations(file2.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)("Error blocks were not cleaned up for file " + file2), (locations.locatedBlockCount() == 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(fs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClientDeath() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        System.out.println("Testing adbornal client death.");
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsclient = dfs.dfs;
        try {
            Path file1 = new Path("/clienttest.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            System.out.println("Created file clienttest.dat");
            TestFileCreation.writeFile(stm);
            dfsclient.close();
            Assert.assertTrue((String)(file1 + " does not exist."), (boolean)AppendTestUtil.createHdfsWithDifferentUsername(conf).exists(file1));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFileCreationSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testFileCreation();
        this.simulatedStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentFileCreation() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        try {
            int i;
            FileSystem fs = cluster.getFileSystem();
            Path[] p = new Path[]{new Path("/foo"), new Path("/bar")};
            FSDataOutputStream[] out = new FSDataOutputStream[]{fs.create(p[0]), fs.create(p[1])};
            for (i = 0; i < 100; ++i) {
                out[0].write(i);
                out[1].write(i);
            }
            out[0].close();
            while (i < 200) {
                out[1].write(i);
                ++i;
            }
            out[1].close();
            FSDataInputStream[] in = new FSDataInputStream[]{fs.open(p[0]), fs.open(p[1])};
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)i, (long)in[0].read());
            }
            for (i = 0; i < 200; ++i) {
                Assert.assertEquals((long)i, (long)in[1].read());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseExpireHardLimit() throws Exception {
        System.out.println("testLeaseExpireHardLimit start");
        long leasePeriod = 1000L;
        int DATANODE_NUM = 3;
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            String f = DIR + "foo";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something".getBytes());
            out.sync();
            int actualRepl = ((DFSClient.DFSOutputStream)out.getWrappedStream()).getNumCurrentReplicas();
            Assert.assertTrue((String)(f + " should be replicated to " + 3 + " datanodes."), (actualRepl == 3 ? 1 : 0) != 0);
            cluster.setLeasePeriod(1000L, 1000L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            LocatedBlocks locations = dfs.dfs.namenode.getBlockLocations(f, 0L, Long.MAX_VALUE);
            Assert.assertEquals((long)1L, (long)locations.locatedBlockCount());
            LocatedBlock locatedblock = (LocatedBlock)locations.getLocatedBlocks().get(0);
            int successcount = 0;
            for (DatanodeInfo datanodeinfo : locatedblock.getLocations()) {
                DataNode datanode = cluster.getDataNode(datanodeinfo.ipcPort);
                FSDataset dataset = (FSDataset)datanode.data;
                Block b = dataset.getStoredBlock(locatedblock.getBlock().getBlockId());
                File blockfile = dataset.findBlockFile(b.getBlockId());
                System.out.println("blockfile=" + blockfile);
                if (blockfile == null) continue;
                BufferedReader in = new BufferedReader(new FileReader(blockfile));
                Assert.assertEquals((Object)"something", (Object)in.readLine());
                in.close();
                ++successcount;
            }
            System.out.println("successcount=" + successcount);
            Assert.assertTrue((successcount > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
        System.out.println("testLeaseExpireHardLimit successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsClose() throws Exception {
        System.out.println("test file system close start");
        int DATANODE_NUM = 3;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            String f = DIR + "foofs";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something".getBytes());
            dfs.close();
        }
        finally {
            System.out.println("testFsClose successful");
        }
    }
}

