/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestFileLengthOnClusterRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileLengthWithHSyncAndClusterRestartWithOutDNsRegister() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.block.size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        DFSClient.DFSDataInputStream in = null;
        FSDataOutputStream out = null;
        DistributedFileSystem dfs = null;
        try {
            Path path = new Path(MiniDFSCluster.getBaseDir().getPath(), "test");
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            out = dfs.create(path);
            int fileLength = 1030;
            out.write(new byte[fileLength]);
            out.sync();
            cluster.restartNameNode();
            cluster.waitActive();
            in = (DFSClient.DFSDataInputStream)dfs.open(path, 1024);
            Assert.assertEquals((long)fileLength, (long)in.getVisibleLength());
            cluster.shutdownDataNodes();
            cluster.restartNameNode(false);
            this.verifyNNIsInSafeMode(dfs);
            try {
                in = (DFSClient.DFSDataInputStream)dfs.open(path);
                Assert.fail((String)"Expected IOException");
            }
            catch (IOException e) {
                Assert.assertTrue((e.getLocalizedMessage().indexOf("Name node is in safe mode") >= 0 ? 1 : 0) != 0);
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != dfs) {
                dfs.dfs.clientRunning = false;
            }
            cluster.shutdown();
        }
    }

    private void verifyNNIsInSafeMode(DistributedFileSystem dfs) throws IOException {
        while (true) {
            try {
                if (dfs.dfs.namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET)) {
                    return;
                }
                throw new IOException("Expected to be in SafeMode");
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }
}

