/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.net.SocketFactory;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class TestGetBlocks
extends TestCase {
    private static final int blockSize = 8192;
    private static final String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
    private static final int numDatanodes = racks.length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadSelectNonStaleDatanode() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.check.stale.datanode", true);
        long staleInterval = 1800000L;
        long heartbeatInterval = 900L;
        conf.setLong("dfs.namenode.stale.datanode.interval", staleInterval);
        conf.setLong("dfs.heartbeat.interval", heartbeatInterval);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, numDatanodes, true, racks);
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, conf);
        ArrayList nodeInfoList = cluster.getNameNode().getNamesystem().getDatanodeListForReport(FSConstants.DatanodeReportType.LIVE);
        TestGetBlocks.assertEquals((String)"Unexpected number of datanodes", (int)numDatanodes, (int)nodeInfoList.size());
        FileSystem fileSys = cluster.getFileSystem();
        FSDataOutputStream stm = null;
        try {
            Path fileName = new Path("/file1");
            stm = fileSys.create(fileName, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
            stm.write(new byte[12288]);
            stm.sync();
            LocatedBlocks blocks = cluster.getNameNode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfo[] nodes = blocks.get(0).getLocations();
            TestGetBlocks.assertEquals((int)nodes.length, (int)3);
            for (DataNode dn : cluster.getDataNodes()) {
                if (!dn.getHostName().equals(nodes[0].getHostName())) continue;
                DatanodeDescriptor staleNodeInfo = cluster.getNameNode().getNamesystem().getDatanode((DatanodeID)dn.dnRegistration);
                staleNodeInfo.setLastUpdate(System.currentTimeMillis() - staleInterval - 1L);
            }
            LocatedBlocks blocksAfterStale = cluster.getNameNode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfo[] nodesAfterStale = blocksAfterStale.get(0).getLocations();
            TestGetBlocks.assertEquals((int)nodesAfterStale.length, (int)3);
            TestGetBlocks.assertEquals((String)nodesAfterStale[2].getHostName(), (String)nodes[0].getHostName());
        }
        finally {
            if (stm != null) {
                stm.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBlocks() throws Exception {
        Configuration CONF = new Configuration();
        int REPLICATION_FACTOR = 2;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.block.size", 1024L);
        MiniDFSCluster cluster = new MiniDFSCluster(CONF, 2, true, null);
        try {
            boolean notWritten;
            long fileLen;
            int bytesToWriteNext;
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(new Path("/tmp.txt"), (short)2);
            byte[] data = new byte[1024];
            for (long bytesToWrite = fileLen = 2048L; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                r.nextBytes(data);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(data, 0, bytesToWriteNext);
            }
            out.close();
            DatanodeInfo[] dataNodes = null;
            block6: do {
                DFSClient dfsclient = new DFSClient(NameNode.getAddress((Configuration)CONF), CONF);
                List locatedBlocks = dfsclient.namenode.getBlockLocations("/tmp.txt", 0L, fileLen).getLocatedBlocks();
                TestGetBlocks.assertEquals((int)2, (int)locatedBlocks.size());
                notWritten = false;
                for (int i = 0; i < 2; ++i) {
                    dataNodes = ((LocatedBlock)locatedBlocks.get(i)).getLocations();
                    if (dataNodes.length == 2) continue;
                    notWritten = true;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
            } while (notWritten);
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            NamenodeProtocol namenode = (NamenodeProtocol)RPC.getProxy(NamenodeProtocol.class, (long)3L, (InetSocketAddress)addr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)CONF, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)CONF));
            BlocksWithLocations.BlockWithLocations[] locs = namenode.getBlocks(dataNodes[0], fileLen).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)2);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            TestGetBlocks.assertEquals((int)locs[1].getDatanodes().length, (int)2);
            locs = namenode.getBlocks(dataNodes[0], 1024L).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)1);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            locs = namenode.getBlocks(dataNodes[0], 1L).getBlocks();
            TestGetBlocks.assertEquals((int)locs.length, (int)1);
            TestGetBlocks.assertEquals((int)locs[0].getDatanodes().length, (int)2);
            this.getBlocksWithException(namenode, dataNodes[0], 0L);
            this.getBlocksWithException(namenode, dataNodes[0], -1L);
            this.getBlocksWithException(namenode, new DatanodeInfo(), 2L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void getBlocksWithException(NamenodeProtocol namenode, DatanodeInfo datanode, long size) throws IOException {
        boolean getException = false;
        try {
            namenode.getBlocks(new DatanodeInfo(), 2L);
        }
        catch (RemoteException e) {
            getException = true;
            TestGetBlocks.assertTrue((boolean)e.getMessage().contains("IllegalArgumentException"));
        }
        TestGetBlocks.assertTrue((boolean)getException);
    }

    public void testGenerationStampWildCard() {
        int i;
        HashMap<Block, Long> map = new HashMap<Block, Long>();
        Random RAN = new Random();
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        long[] blkids = new long[10];
        for (i = 0; i < blkids.length; ++i) {
            blkids[i] = 1000L + (long)RAN.nextInt(100000);
            map.put(new Block(blkids[i], 0L, blkids[i]), blkids[i]);
        }
        System.out.println("map=" + ((Object)map).toString().replace(",", "\n  "));
        for (i = 0; i < blkids.length; ++i) {
            Block b = new Block(blkids[i], 0L, 1L);
            Long v = (Long)map.get(b);
            System.out.println(b + " => " + v);
            TestGetBlocks.assertEquals((long)blkids[i], (long)v);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestGetBlocks().testGetBlocks();
    }
}

