/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public class TestSafeMode {
    static Log LOG = LogFactory.getLog(TestSafeMode.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualSafeMode() throws IOException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/tmp/testManualSafeMode/file1");
            Path file2 = new Path("/tmp/testManualSafeMode/file2");
            LOG.info((Object)"Created file1 and file2.");
            DFSTestUtil.createFile(fs, file1, 1000L, (short)1, 0L);
            DFSTestUtil.createFile(fs, file2, 2000L, (short)1, 0L);
            cluster.shutdown();
            cluster = new MiniDFSCluster(conf, 0, false, null);
            cluster.waitActive();
            LOG.info((Object)"Restarted cluster with just the NameNode");
            NameNode namenode = cluster.getNameNode();
            Assert.assertTrue((String)"No datanode is started. Should be in SafeMode", (boolean)namenode.isInSafeMode());
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.startDataNodes(conf, 1, true, null, null);
            cluster.waitActive();
            LOG.info((Object)"Datanode is started.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            Assert.assertTrue((String)"should still be in SafeMode", (boolean)namenode.isInSafeMode());
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            Assert.assertFalse((String)"should not be in SafeMode", (boolean)namenode.isInSafeMode());
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSafeModeWhenZeroBlockLocations() throws IOException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            NameNode namenode;
            Path file1;
            block8: {
                Configuration conf = new Configuration();
                conf.set("dfs.safemode.extension", "1");
                cluster = new MiniDFSCluster(conf, 1, true, null);
                cluster.waitActive();
                fs = cluster.getFileSystem();
                file1 = new Path("/tmp/testManualSafeMode/file1");
                Path file2 = new Path("/tmp/testManualSafeMode/file2");
                LOG.info((Object)"Created file1 and file2.");
                DFSTestUtil.createFile(fs, file1, 1000L, (short)1, 0L);
                DFSTestUtil.createFile(fs, file2, 2000L, (short)1, 0L);
                this.checkGetBlockLocationsWorks(fs, file1);
                namenode = cluster.getNameNode();
                namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
                Assert.assertTrue((String)"should still be in SafeMode", (boolean)namenode.isInSafeMode());
                this.checkGetBlockLocationsWorks(fs, file1);
                namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
                Assert.assertFalse((String)"should not be in SafeMode", (boolean)namenode.isInSafeMode());
                Assert.assertFalse((String)"should not be in SafeMode", (boolean)namenode.isInSafeMode());
                cluster.shutdownDataNodes();
                cluster.shutdownNameNode();
                cluster.restartNameNode();
                cluster.waitActive();
                LOG.info((Object)"Restarted cluster with just the NameNode");
                namenode = cluster.getNameNode();
                Assert.assertTrue((String)"No datanode is started. Should be in SafeMode", (boolean)namenode.isInSafeMode());
                FileStatus stat = fs.getFileStatus(file1);
                try {
                    fs.getFileBlockLocations(stat, 0L, 1000L);
                    Assert.assertTrue((String)"Should have got safemode exception", (boolean)false);
                }
                catch (SafeModeException e) {
                }
                catch (RemoteException re) {
                    if (re.getClassName().equals(SafeModeException.class.getName())) break block8;
                    Assert.assertTrue((String)"Should have got safemode exception", (boolean)false);
                }
            }
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            Assert.assertFalse((String)"Should not be in safemode", (boolean)namenode.isInSafeMode());
            this.checkGetBlockLocationsWorks(fs, file1);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    void checkGetBlockLocationsWorks(FileSystem fs, Path fileName) throws IOException {
        FileStatus stat = fs.getFileStatus(fileName);
        try {
            fs.getFileBlockLocations(stat, 0L, 1000L);
        }
        catch (SafeModeException e) {
            Assert.assertTrue((String)"Should have not got safemode exception", (boolean)false);
        }
        catch (RemoteException re) {
            Assert.assertTrue((String)"Should have not got safemode exception", (boolean)false);
        }
    }
}

