/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDataBlockScanner {
    static final int blockSize = 8192;
    private MiniDFSCluster cluster;
    private FileSystem fileSystem;

    public TestDataBlockScanner() {
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
    }

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.init(conf);
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void init(Configuration conf) throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster(conf, 1, true, null);
        this.cluster.waitClusterUp();
        this.fileSystem = this.cluster.getFileSystem();
    }

    @Test
    public void testPrematureDataBlockScannerAdd() throws IOException {
        Path file1 = new Path("/unfinished-block");
        FSDataOutputStream out = this.fileSystem.create(file1);
        int writeSize = 4096;
        out.write(DFSTestUtil.generateSequentialBytes(0, writeSize));
        out.sync();
        FSDataInputStream in = this.fileSystem.open(file1);
        byte[] buf = new byte[4096];
        in.readFully(0L, buf);
        in.close();
        this.waitForBlocks(this.fileSystem, file1, 1, writeSize);
        int blockMapSize = this.cluster.getDataNodes().get((int)0).blockScanner.blockMap.size();
        Assert.assertEquals((String)String.format("%d entries in blockMap and it should be empty", blockMapSize), (long)0L, (long)blockMapSize);
        out.close();
    }

    private void waitForBlocks(FileSystem fileSys, Path name, int blockCount, long length) throws IOException {
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, length);
            if (locations.length >= blockCount) continue;
            done = false;
        }
    }
}

