/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileAppend4;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeInstrumentation;
import org.apache.log4j.Level;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestStuckDataNode
extends TestCase {
    public TestStuckDataNode() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStuckDataNode() throws Exception {
        int DATANODE_NUM = 3;
        Configuration conf = new Configuration();
        int timeout = 8000;
        conf.setInt("dfs.socket.timeout", 8000);
        Path p = new Path("/pipelineHeartbeat/foo");
        System.out.println("p=" + p);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        DistributedFileSystem fs = (DistributedFileSystem)cluster.getFileSystem();
        DataNodeInstrumentation metrics = (DataNodeInstrumentation)Mockito.spy((Object)cluster.getDataNodes().get((int)0).myMetrics);
        TestFileAppend4.DelayAnswer delayAnswer = new TestFileAppend4.DelayAnswer();
        ((DataNodeInstrumentation)Mockito.doAnswer((Answer)delayAnswer).when((Object)metrics)).incrBytesWritten(Matchers.anyInt());
        try {
            FSDataOutputStream stm = fs.create(p);
            stm.write(1);
            stm.sync();
            stm.write(2);
            stm.close();
            FSDataInputStream in = fs.open(p);
            TestStuckDataNode.assertEquals((int)1, (int)in.read());
            TestStuckDataNode.assertEquals((int)2, (int)in.read());
            in.close();
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

