/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeRecovery {
    private static final Log LOG = LogFactory.getLog(TestNameNodeRecovery.class);
    private static HdfsConstants.StartupOption recoverStartOpt = HdfsConstants.StartupOption.RECOVER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRecoverTruncatedEditLog() throws IOException {
        String TEST_PATH = "/test/path/dir";
        String TEST_PATH2 = "/alt/test/path";
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(0, conf, 0, true, true, false, HdfsConstants.StartupOption.FORMAT, null, null, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        fileSys.mkdirs(new Path("/test/path/dir"));
        fileSys.mkdirs(new Path("/alt/test/path"));
        List nameEditsDirs = (List)FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
        cluster.shutdown();
        File dir = (File)nameEditsDirs.get(0);
        File editFile = new File(new File(dir, "current"), FSImage.NameNodeFile.EDITS.getName());
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        long fileLen = editFile.length();
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.setLength(fileLen - 1L);
        rwf.close();
        try {
            LOG.debug((Object)"trying to start normally (this should fail)...");
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.REGULAR, null, null, null);
            cluster.waitActive();
            Assert.fail((String)"expected the truncated edit log to prevent normal startup");
        }
        catch (IOException e) {
        }
        finally {
            cluster.shutdown();
        }
        try {
            LOG.debug((Object)"running recovery...");
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.RECOVER, null, null, null);
            cluster.waitActive();
        }
        catch (IOException e) {
            Assert.fail((String)("caught IOException while trying to recover. message was " + e.getMessage() + "\nstack trace\n" + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            cluster.shutdown();
        }
        try {
            cluster = new MiniDFSCluster(0, conf, 0, false, true, false, HdfsConstants.StartupOption.REGULAR, null, null, null);
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(new Path("/test/path/dir")));
        }
        catch (IOException e) {
            Assert.fail((String)("failed to recover.  Error message: " + e.getMessage()));
        }
        finally {
            cluster.shutdown();
        }
        LOG.debug((Object)"testRecoverTruncatedEditLog: successfully recovered the truncated edit log");
    }

    static {
        recoverStartOpt.setForce(2);
    }
}

