/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestNodeCount
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeCount() throws Exception {
        Configuration conf = new Configuration();
        int REPLICATION_FACTOR = 2;
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        try {
            FSNamesystem namesystem = cluster.getNameNode().namesystem;
            FileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/testfile");
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication(fs, FILE_PATH, (short)2);
            Block block = DFSTestUtil.getFirstBlock(fs, FILE_PATH);
            DatanodeDescriptor[] datanodes = namesystem.heartbeats.toArray(new DatanodeDescriptor[2]);
            cluster.startDataNodes(conf, 2, true, null, null);
            cluster.waitActive();
            DatanodeDescriptor datanode = datanodes[0];
            MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(datanode.getName());
            ArrayList arrayList = namesystem.heartbeats;
            synchronized (arrayList) {
                datanode.setLastUpdate(0L);
                namesystem.heartbeatCheck();
            }
            DFSTestUtil.waitReplication(fs, FILE_PATH, (short)2);
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            FSNamesystem.NumberReplicas num = null;
            do {
                FSNamesystem fSNamesystem = namesystem;
                synchronized (fSNamesystem) {
                    num = namesystem.countNodes(block);
                }
            } while (num.excessReplicas() == 0);
            Iterator iter = namesystem.blocksMap.nodeIterator(block);
            DatanodeDescriptor nonExcessDN = null;
            while (iter.hasNext()) {
                DatanodeDescriptor dn = (DatanodeDescriptor)iter.next();
                Collection blocks = (Collection)namesystem.excessReplicateMap.get(dn.getStorageID());
                if (blocks != null && blocks.contains(block)) continue;
                nonExcessDN = dn;
                break;
            }
            TestNodeCount.assertTrue((nonExcessDN != null ? 1 : 0) != 0);
            dnprop = cluster.stopDataNode(nonExcessDN.getName());
            ArrayList arrayList2 = namesystem.heartbeats;
            synchronized (arrayList2) {
                nonExcessDN.setLastUpdate(0L);
                namesystem.heartbeatCheck();
            }
            while ((num = namesystem.countNodes(block)).liveReplicas() != 2) {
            }
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            while ((num = namesystem.countNodes(block)).excessReplicas() != 2) {
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

