/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestMapFile
extends TestCase {
    private static Configuration conf = new Configuration();

    public void testGetClosest() throws Exception {
        Path dirName = new Path(System.getProperty("test.build.data", ".") + this.getName() + ".mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)3);
        MapFile.Writer writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, Text.class);
        TestMapFile.assertEquals((int)3, (int)writer.getIndexInterval());
        int FIRST_KEY = 10;
        for (int i = 10; i < 100; i += 10) {
            String iStr = Integer.toString(i);
            Text t = new Text("00".substring(iStr.length()) + iStr);
            writer.append((WritableComparable)t, (Writable)t);
        }
        writer.close();
        MapFile.Reader reader = new MapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        Text key = new Text("55");
        Text value = new Text();
        Text closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
        TestMapFile.assertEquals((Object)new Text("60"), (Object)closest);
        closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
        TestMapFile.assertEquals((Object)new Text("50"), (Object)closest);
        Text TWENTY = new Text("20");
        closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value);
        TestMapFile.assertEquals((Object)TWENTY, (Object)closest);
        closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value, true);
        TestMapFile.assertEquals((Object)TWENTY, (Object)closest);
        key = new Text("00");
        closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
        TestMapFile.assertEquals((int)10, (int)Integer.parseInt(closest.toString()));
        closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
        TestMapFile.assertNull((Object)closest);
        key = new Text("99");
        closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
        TestMapFile.assertNull((Object)closest);
        closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
        TestMapFile.assertEquals((Object)new Text("90"), (Object)closest);
    }
}

