/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskTracker;

public class TestLRUCache
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestLRUCache.class);

    public void testPut() {
        TaskTracker.LRUCache cache = new TaskTracker.LRUCache(200);
        for (int i = 0; i < 200; ++i) {
            cache.put((Object)(i + ""), (Object)new Path("/foo" + i));
        }
        Iterator iterator = cache.getIterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            Path val = (Path)entry.getValue();
            TestLRUCache.assertEquals((String)(i + ""), (String)key);
            ++i;
        }
        LOG.info((Object)"Completed testPut");
    }

    public void testGet() {
        int i;
        TaskTracker.LRUCache cache = new TaskTracker.LRUCache(200);
        for (i = 0; i < 200; ++i) {
            cache.put((Object)(i + ""), (Object)new Path("/foo" + i));
        }
        for (i = 0; i < 200; ++i) {
            Path path = (Path)cache.get((Object)(i + ""));
            TestLRUCache.assertEquals((String)path.toString(), (String)new Path("/foo" + i).toString());
        }
        LOG.info((Object)"Completed testGet");
    }

    public void testClear() {
        TaskTracker.LRUCache cache = new TaskTracker.LRUCache(200);
        for (int i = 0; i < 200; ++i) {
            cache.put((Object)(i + ""), (Object)new Path("/foo" + i));
        }
        cache.clear();
        TestLRUCache.assertTrue((cache.size() == 0 ? 1 : 0) != 0);
        LOG.info((Object)"Completed testClear");
    }

    public void testOverFlow() {
        int i;
        TaskTracker.LRUCache cache = new TaskTracker.LRUCache(200);
        int SIZE = 5000;
        for (i = 0; i < SIZE; ++i) {
            cache.put((Object)(i + ""), (Object)new Path("/foo" + i));
        }
        for (i = SIZE - 1; i >= SIZE - 200; --i) {
            Path path = (Path)cache.get((Object)(i + ""));
            TestLRUCache.assertEquals((String)path.toString(), (String)new Path("/foo" + i).toString());
        }
        LOG.info((Object)"Completed testOverFlow");
    }
}

