/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Progressable;

public class TestSpecialCharactersInOutputPath
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestSpecialCharactersInOutputPath.class.getName());
    private static final String OUTPUT_FILENAME = "result[0]";

    public static boolean launchJob(String fileSys, String jobTracker, JobConf conf, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/input");
        Path outDir = new Path("/testing/output");
        FileSystem fs = FileSystem.getNamed((String)fileSys, (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            LOG.warn((Object)("Can't create " + inDir));
            return false;
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("foo foo2 foo3");
        file.close();
        FileSystem.setDefaultUri((Configuration)conf, (String)fileSys);
        conf.set("mapred.job.tracker", jobTracker);
        conf.setJobName("foo");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SpecialTextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        RunningJob runningJob = JobClient.runJob((JobConf)conf);
        try {
            TestSpecialCharactersInOutputPath.assertTrue((boolean)runningJob.isComplete());
            TestSpecialCharactersInOutputPath.assertTrue((boolean)runningJob.isSuccessful());
            TestSpecialCharactersInOutputPath.assertTrue((String)"Output folder not found!", (boolean)fs.exists(new Path("/testing/output/result[0]")));
        }
        catch (NullPointerException npe) {
            TestSpecialCharactersInOutputPath.fail((String)"A NPE should not have happened.");
        }
        LOG.info((Object)("job is complete: " + runningJob.isSuccessful()));
        return runningJob.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobWithDFS() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            int jobTrackerPort = 60050;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getName();
            mr = new MiniMRCluster(4, namenode, 2);
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            JobConf jobConf = new JobConf();
            boolean result = TestSpecialCharactersInOutputPath.launchJob(namenode, jobTrackerName, jobConf, 3, 1);
            TestSpecialCharactersInOutputPath.assertTrue((boolean)result);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class SpecialTextOutputFormat<K, V>
    extends TextOutputFormat<K, V> {
        SpecialTextOutputFormat() {
        }

        public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            return super.getRecordWriter(ignored, job, TestSpecialCharactersInOutputPath.OUTPUT_FILENAME, progress);
        }
    }
}

