/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskGraphServlet;
import org.apache.hadoop.mapred.TaskReport;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskGraphServlet {
    @Test
    public void testTaskGraphServletShouldNotReturnEmptyContForNotasks() throws Exception {
        String jobId = "job_201108291216_0002";
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)jobId).when((Object)request)).getParameter("jobid");
        ((HttpServletRequest)Mockito.doReturn((Object)"map").when((Object)request)).getParameter("type");
        JobTracker jobTracker = (JobTracker)Mockito.mock(JobTracker.class);
        ((JobTracker)Mockito.doReturn((Object)new TaskReport[0]).when((Object)jobTracker)).getMapTaskReports(JobID.forName((String)jobId));
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        ((ServletContext)Mockito.doReturn((Object)jobTracker).when((Object)servletContext)).getAttribute("job.tracker");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        PrintWriter printWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
        ((HttpServletResponse)Mockito.doReturn((Object)printWriter).when((Object)response)).getWriter();
        TaskGraphServlet taskGraphServlet = this.getTaskGraphServlet(servletContext);
        taskGraphServlet.doGet(request, response);
        ((PrintWriter)Mockito.verify((Object)printWriter, (VerificationMode)Mockito.atLeastOnce())).print("</svg>");
    }

    private TaskGraphServlet getTaskGraphServlet(final ServletContext servletContext) {
        TaskGraphServlet taskGraphServlet = new TaskGraphServlet(){
            private static final long serialVersionUID = 1L;

            public ServletContext getServletContext() {
                return servletContext;
            }
        };
        return taskGraphServlet;
    }
}

