/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.NoSuchElementException;
import org.apache.hadoop.metrics2.util.TryIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestTryIterator {
    @Test
    public void testCommonIteration() {
        TryIterator<Integer> it = new TryIterator<Integer>(){
            private int count = 0;

            protected Integer tryNext() {
                switch (this.count++) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return (Integer)this.done();
                    }
                }
                Assert.fail((String)"Should not reach here");
                return null;
            }
        };
        Assert.assertTrue((String)"has next", (boolean)it.hasNext());
        Assert.assertEquals((String)"next", (long)0L, (long)((Integer)it.next()).intValue());
        Assert.assertTrue((String)"has next", (boolean)it.hasNext());
        Assert.assertTrue((String)"has next", (boolean)it.hasNext());
        Assert.assertEquals((String)"current", (long)1L, (long)((Integer)((TryIterator)it).current()).intValue());
        Assert.assertEquals((String)"current 1", (long)1L, (long)((Integer)((TryIterator)it).current()).intValue());
        Assert.assertEquals((String)"next", (long)1L, (long)((Integer)it.next()).intValue());
        Assert.assertTrue((String)"no next", (!it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((String)"no next", (!it.hasNext() ? 1 : 0) != 0);
        try {
            it.next();
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException expected) {
            expected.getCause();
        }
    }

    @Test
    public void testEmptyIteration() {
        TryIterator<Integer> it = new TryIterator<Integer>(){
            private boolean doneDone = false;

            public Integer tryNext() {
                if (this.doneDone) {
                    Assert.fail((String)"Should not be called again");
                }
                this.doneDone = true;
                return (Integer)this.done();
            }
        };
        Assert.assertTrue((String)"should not has next", (!it.hasNext() ? 1 : 0) != 0);
        try {
            it.current();
            Assert.fail((String)"should throw");
        }
        catch (NoSuchElementException expected) {
            expected.getCause();
        }
        try {
            it.next();
            Assert.fail((String)"should throw");
        }
        catch (NoSuchElementException expected) {
            expected.getCause();
        }
    }

    @Test
    public void testExceptionInTryNext() {
        final RuntimeException exception = new RuntimeException("expected");
        TryIterator<Integer> it = new TryIterator<Integer>(){

            public Integer tryNext() {
                throw exception;
            }
        };
        try {
            it.hasNext();
            Assert.fail((String)"should throw");
        }
        catch (Exception expected) {
            Assert.assertSame((Object)exception, (Object)expected);
        }
    }

    @Test
    public void testRemove() {
        TryIterator<Integer> it = new TryIterator<Integer>(){
            private boolean called = false;

            public Integer tryNext() {
                if (this.called) {
                    return (Integer)this.done();
                }
                this.called = true;
                return 0;
            }
        };
        Assert.assertEquals((String)"should be 0", (long)0L, (long)((Integer)it.next()).intValue());
        try {
            it.remove();
        }
        catch (UnsupportedOperationException expected) {
            expected.getCause();
        }
    }

    @Test
    public void testHasNextInTryNext() {
        TryIterator<Integer> it = new TryIterator<Integer>(){

            public Integer tryNext() {
                this.hasNext();
                return null;
            }
        };
        try {
            it.hasNext();
            Assert.fail((String)"should throw");
        }
        catch (IllegalStateException expected) {
            expected.getCause();
        }
    }
}

