/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import junit.framework.TestCase;
import org.apache.hadoop.record.Buffer;

public class TestBuffer
extends TestCase {
    public TestBuffer(String testName) {
        super(testName);
    }

    public void testSet() {
        byte[] bytes = new byte[10];
        Buffer instance = new Buffer();
        instance.set(bytes);
        TestBuffer.assertEquals((String)"set failed", (Object)bytes, (Object)instance.get());
    }

    public void testCopy() {
        byte[] bytes = new byte[10];
        int offset = 6;
        int length = 3;
        for (int idx = 0; idx < 10; ++idx) {
            bytes[idx] = (byte)idx;
        }
        Buffer instance = new Buffer();
        instance.copy(bytes, 6, 3);
        TestBuffer.assertEquals((String)"copy failed", (int)3, (int)instance.getCapacity());
        TestBuffer.assertEquals((String)"copy failed", (int)3, (int)instance.get().length);
        for (int idx = 0; idx < 3; ++idx) {
            TestBuffer.assertEquals((String)"Buffer content corrupted", (int)(idx + 6), (int)instance.get()[idx]);
        }
    }

    public void testGetCount() {
        Buffer instance = new Buffer();
        boolean expResult = false;
        int result = instance.getCount();
        TestBuffer.assertEquals((String)"getSize failed", (int)0, (int)result);
    }

    public void testGetCapacity() {
        Buffer instance = new Buffer();
        boolean expResult = false;
        int result = instance.getCapacity();
        TestBuffer.assertEquals((String)"getCapacity failed", (int)0, (int)result);
        instance.setCapacity(100);
        TestBuffer.assertEquals((String)"setCapacity failed", (int)100, (int)instance.getCapacity());
    }

    public void testTruncate() {
        Buffer instance = new Buffer();
        instance.setCapacity(100);
        TestBuffer.assertEquals((String)"setCapacity failed", (int)100, (int)instance.getCapacity());
        instance.truncate();
        TestBuffer.assertEquals((String)"truncate failed", (int)0, (int)instance.getCapacity());
    }

    public void testAppend() {
        byte[] bytes = new byte[100];
        boolean offset = false;
        int length = 100;
        for (int idx = 0; idx < 100; ++idx) {
            bytes[idx] = (byte)(100 - idx);
        }
        Buffer instance = new Buffer();
        instance.append(bytes, 0, 100);
        TestBuffer.assertEquals((String)"Buffer size mismatch", (int)100, (int)instance.getCount());
        for (int idx = 0; idx < 100; ++idx) {
            TestBuffer.assertEquals((String)"Buffer contents corrupted", (int)(100 - idx), (int)instance.get()[idx]);
        }
    }
}

