/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDelegationTokenFetcher {
    private DistributedFileSystem dfs;
    private Configuration conf;
    private URI uri;
    private static final String SERVICE_VALUE = "localhost:2005";
    private static final Text KIND = new Text("TESTING-TOKEN-KIND");

    @Before
    public void init() throws URISyntaxException, IOException {
        this.dfs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        this.conf = new Configuration();
        this.uri = new URI("hdfs://localhost:2005");
        FileSystem.addFileSystemForTesting((URI)this.uri, (Configuration)this.conf, (FileSystem)this.dfs);
    }

    @Test
    public void expectedTokenIsRetrievedFromDFS() throws Exception {
        byte[] ident = new byte[]{1, 2, 3, 4};
        byte[] pw = new byte[]{42};
        Text service = new Text(this.uri.toString());
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Token t = new Token(ident, pw, KIND, service);
        Mockito.when((Object)this.dfs.getDelegationToken((String)Matchers.eq((Object)user))).thenReturn((Object)t);
        Mockito.when((Object)this.dfs.renewDelegationToken((Token)Matchers.eq((Object)t))).thenReturn((Object)1000L);
        FakeRenewer.reset();
        DelegationTokenFetcher.main((String[])new String[]{"-fs", this.uri.toString(), "file.dta"});
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path p = new Path(fs.getWorkingDirectory(), "file.dta");
        Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
        Iterator itr = creds.getAllTokens().iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)t, itr.next());
        Assert.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        DelegationTokenFetcher.main((String[])new String[]{"--renew", "file.dta"});
        Assert.assertEquals((Object)t, FakeRenewer.lastRenewed);
        FakeRenewer.reset();
        DelegationTokenFetcher.main((String[])new String[]{"--cancel", "file.dta"});
        Assert.assertEquals((Object)t, FakeRenewer.lastCanceled);
    }

    public static class FakeRenewer
    extends TokenRenewer {
        static Token<?> lastRenewed = null;
        static Token<?> lastCanceled = null;

        public boolean handleKind(Text kind) {
            return KIND.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) {
            lastRenewed = token;
            return 0L;
        }

        public void cancel(Token<?> token, Configuration conf) {
            lastCanceled = token;
        }

        public static void reset() {
            lastRenewed = null;
            lastCanceled = null;
        }
    }
}

