/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.kfs.IFSImpl;
import org.apache.hadoop.fs.kfs.KFSEmulationImpl;
import org.apache.hadoop.fs.kfs.KosmosFileSystem;

public class TestKosmosFileSystem
extends TestCase {
    KosmosFileSystem kosmosFileSystem;
    KFSEmulationImpl kfsEmul;
    Path baseDir;

    protected void setUp() throws IOException {
        Configuration conf = new Configuration();
        this.kfsEmul = new KFSEmulationImpl(conf);
        this.kosmosFileSystem = new KosmosFileSystem((IFSImpl)this.kfsEmul);
        this.kosmosFileSystem.initialize(URI.create("kfs:///"), conf);
        this.baseDir = new Path(System.getProperty("test.build.data", "/tmp") + "/kfs-test");
    }

    protected void tearDown() throws Exception {
    }

    public void testDirs() throws Exception {
        Path subDir1 = new Path("dir.1");
        this.kosmosFileSystem.mkdirs(this.baseDir);
        TestKosmosFileSystem.assertTrue((boolean)this.kosmosFileSystem.isDirectory(this.baseDir));
        this.kosmosFileSystem.setWorkingDirectory(this.baseDir);
        this.kosmosFileSystem.mkdirs(subDir1);
        TestKosmosFileSystem.assertTrue((boolean)this.kosmosFileSystem.isDirectory(subDir1));
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(new Path("test1")));
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.isDirectory(new Path("test/dir.2")));
        FileStatus[] p = this.kosmosFileSystem.listStatus(this.baseDir);
        TestKosmosFileSystem.assertEquals((int)p.length, (int)1);
        this.kosmosFileSystem.delete(this.baseDir, true);
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(this.baseDir));
    }

    public void testFiles() throws Exception {
        Path subDir1 = new Path("dir.1");
        Path file1 = new Path("dir.1/foo.1");
        Path file2 = new Path("dir.1/foo.2");
        this.kosmosFileSystem.mkdirs(this.baseDir);
        TestKosmosFileSystem.assertTrue((boolean)this.kosmosFileSystem.isDirectory(this.baseDir));
        this.kosmosFileSystem.setWorkingDirectory(this.baseDir);
        this.kosmosFileSystem.mkdirs(subDir1);
        FSDataOutputStream s1 = this.kosmosFileSystem.create(file1, true, 4096, (short)1, 4096L, null);
        FSDataOutputStream s2 = this.kosmosFileSystem.create(file2, true, 4096, (short)1, 4096L, null);
        s1.close();
        s2.close();
        FileStatus[] p = this.kosmosFileSystem.listStatus(subDir1);
        TestKosmosFileSystem.assertEquals((int)p.length, (int)2);
        this.kosmosFileSystem.delete(file1, true);
        p = this.kosmosFileSystem.listStatus(subDir1);
        TestKosmosFileSystem.assertEquals((int)p.length, (int)1);
        this.kosmosFileSystem.delete(file2, true);
        p = this.kosmosFileSystem.listStatus(subDir1);
        TestKosmosFileSystem.assertEquals((int)p.length, (int)0);
        this.kosmosFileSystem.delete(this.baseDir, true);
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(this.baseDir));
    }

    public void testFileIO() throws Exception {
        Path subDir1 = new Path("dir.1");
        Path file1 = new Path("dir.1/foo.1");
        this.kosmosFileSystem.mkdirs(this.baseDir);
        TestKosmosFileSystem.assertTrue((boolean)this.kosmosFileSystem.isDirectory(this.baseDir));
        this.kosmosFileSystem.setWorkingDirectory(this.baseDir);
        this.kosmosFileSystem.mkdirs(subDir1);
        FSDataOutputStream s1 = this.kosmosFileSystem.create(file1, true, 4096, (short)1, 4096L, null);
        int bufsz = 4096;
        byte[] data = new byte[bufsz];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 16);
        }
        s1.write(32);
        s1.write(32);
        s1.write(32);
        s1.write(32);
        s1.write(data, 0, data.length);
        s1.close();
        FSDataInputStream s2 = this.kosmosFileSystem.open(file1, 4096);
        int v = s2.read();
        TestKosmosFileSystem.assertEquals((int)v, (int)32);
        v = s2.read();
        TestKosmosFileSystem.assertEquals((int)v, (int)32);
        v = s2.read();
        TestKosmosFileSystem.assertEquals((int)v, (int)32);
        v = s2.read();
        TestKosmosFileSystem.assertEquals((int)v, (int)32);
        TestKosmosFileSystem.assertEquals((int)s2.available(), (int)data.length);
        byte[] buf = new byte[bufsz];
        s2.read(buf, 0, buf.length);
        for (int i = 0; i < data.length; ++i) {
            TestKosmosFileSystem.assertEquals((byte)data[i], (byte)buf[i]);
        }
        TestKosmosFileSystem.assertEquals((int)s2.available(), (int)0);
        s2.close();
        this.kosmosFileSystem.delete(file1, true);
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(file1));
        this.kosmosFileSystem.delete(subDir1, true);
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(subDir1));
        this.kosmosFileSystem.delete(this.baseDir, true);
        TestKosmosFileSystem.assertFalse((boolean)this.kosmosFileSystem.exists(this.baseDir));
    }
}

