/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;

public class TestLeaseRecovery2
extends TestCase {
    static final long BLOCK_SIZE = 1024L;
    static final int FILE_SIZE = 16384;
    static final short REPLICATION_NUM = 3;
    private static byte[] buffer = new byte[16384];
    private final Configuration conf;
    private final int bufferSize;
    private static String fakeUsername = "fakeUser1";
    private static String fakeGroup = "supergroup";

    public TestLeaseRecovery2() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        this.conf = new Configuration();
        this.bufferSize = this.conf.getInt("io.file.buffer.size", 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockSynchronization() throws Exception {
        long softLease = 1000L;
        long hardLease = 3600000L;
        this.conf.setLong("dfs.block.size", 1024L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(1);
        u2g_map.put(fakeUsername, new String[]{fakeGroup});
        DFSTestUtil.updateConfWithFakeGroupMapping(this.conf, u2g_map);
        MiniDFSCluster cluster = null;
        byte[] actual = new byte[16384];
        try {
            cluster = new MiniDFSCluster(this.conf, 5, true, null);
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            int size = AppendTestUtil.nextInt(16384);
            Path filepath = this.createFile(dfs, size, true);
            cluster.setLeasePeriod(1000L, 3600000L);
            this.recoverLeaseUsingCreate(filepath);
            this.verifyFile((FileSystem)dfs, filepath, actual, size);
            cluster.setLeasePeriod(3600000L, 3600000L);
            size = AppendTestUtil.nextInt(16384);
            filepath = this.createFile(dfs, size, false);
            this.recoverLease(filepath, null);
            this.verifyFile((FileSystem)dfs, filepath, actual, size);
            size = AppendTestUtil.nextInt(16384);
            filepath = this.createFile(dfs, size, false);
            Path filepath1 = new Path("/foo" + AppendTestUtil.nextInt());
            FSDataOutputStream stm = dfs.create(filepath1, true, this.bufferSize, (short)3, 1024L);
            this.recoverLease(filepath, dfs);
            this.verifyFile((FileSystem)dfs, filepath, actual, size);
            stm.write(buffer, 0, size);
            stm.close();
            this.verifyFile((FileSystem)dfs, filepath1, actual, size);
        }
        finally {
            try {
                if (cluster != null) {
                    cluster.getFileSystem().close();
                    cluster.shutdown();
                }
            }
            catch (Exception e) {}
        }
    }

    private void recoverLease(Path filepath, DistributedFileSystem dfs2) throws Exception {
        if (dfs2 == null) {
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fakeUsername, (String[])new String[]{fakeGroup});
            dfs2 = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(ugi, this.conf);
        }
        while (!dfs2.recoverLease(filepath)) {
            AppendTestUtil.LOG.info((Object)"sleep 5000ms");
            Thread.sleep(5000L);
        }
    }

    private Path createFile(DistributedFileSystem dfs, int size, boolean triggerSoftLease) throws IOException, InterruptedException {
        String filestr = "/foo" + AppendTestUtil.nextInt();
        System.out.println("filestr=" + filestr);
        Path filepath = new Path(filestr);
        FSDataOutputStream stm = dfs.create(filepath, true, this.bufferSize, (short)3, 1024L);
        TestLeaseRecovery2.assertTrue((boolean)dfs.dfs.exists(filestr));
        System.out.println("size=" + size);
        stm.write(buffer, 0, size);
        AppendTestUtil.LOG.info((Object)"sync");
        stm.sync();
        if (triggerSoftLease) {
            AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
            dfs.dfs.getLeaseRenewer().interruptAndJoin();
        }
        return filepath;
    }

    private void recoverLeaseUsingCreate(Path filepath) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fakeUsername, (String[])new String[]{fakeGroup});
        FileSystem dfs2 = DFSTestUtil.getFileSystemAs(ugi, this.conf);
        boolean done = false;
        for (int i = 0; i < 10 && !done; ++i) {
            AppendTestUtil.LOG.info((Object)("i=" + i));
            try {
                dfs2.create(filepath, false, this.bufferSize, (short)1, 1024L);
                TestLeaseRecovery2.fail((String)"Creation of an existing file should never succeed.");
            }
            catch (IOException ioe) {
                String message = ioe.getMessage();
                if (message.contains("file exists")) {
                    AppendTestUtil.LOG.info((Object)"done", (Throwable)ioe);
                    done = true;
                }
                if (message.contains(AlreadyBeingCreatedException.class.getSimpleName())) {
                    AppendTestUtil.LOG.info((Object)("GOOD! got " + message));
                }
                AppendTestUtil.LOG.warn((Object)"UNEXPECTED IOException", (Throwable)ioe);
            }
            if (done) continue;
            AppendTestUtil.LOG.info((Object)"sleep 5000ms");
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        TestLeaseRecovery2.assertTrue((boolean)done);
    }

    private void verifyFile(FileSystem dfs, Path filepath, byte[] actual, int size) throws IOException {
        AppendTestUtil.LOG.info((Object)("Lease for file " + filepath + " is recovered. " + "Validating its contents now..."));
        TestLeaseRecovery2.assertTrue((String)("File should be " + size + " bytes, but is actually " + " found to be " + dfs.getFileStatus(filepath).getLen() + " bytes"), (dfs.getFileStatus(filepath).getLen() == (long)size ? 1 : 0) != 0);
        System.out.println("File size is good. Now validating sizes from datanodes...");
        FSDataInputStream stmin = dfs.open(filepath);
        stmin.readFully(0L, actual, 0, size);
        stmin.close();
    }
}

