/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationTokenAuthMethod {
    private MiniDFSCluster cluster;
    Configuration config;

    @Before
    public void setUp() throws Exception {
        this.config = new Configuration();
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.cluster = new MiniDFSCluster(0, this.config, 1, true, true, true, null, null, null, null);
        this.cluster.waitActive();
        this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager().startThreads();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private Token<DelegationTokenIdentifier> generateDelegationToken(String owner, String renewer) {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), null);
        return new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
    }

    @Test
    public void testDelegationTokenNamesystemApi() throws Exception {
        final FSNamesystem namesys = this.cluster.getNameNode().getNamesystem();
        final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    Token token = namesys.getDelegationToken(new Text(ugi.getShortUserName()));
                    namesys.renewDelegationToken(token);
                    namesys.cancelDelegationToken(token);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }
        });
    }

    @Test
    public void testGetDelegationTokenWithoutKerberos() throws Exception {
        final FSNamesystem namesys = this.cluster.getNameNode().getNamesystem();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    namesys.getDelegationToken(new Text("arenewer"));
                    Assert.fail((String)"Delegation token should not be issued without Kerberos authentication");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testRenewDelegationTokenWithoutKerberos() throws Exception {
        final FSNamesystem namesys = this.cluster.getNameNode().getNamesystem();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
        this.config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.config);
        final Token<DelegationTokenIdentifier> token = this.generateDelegationToken("owner", ugi.getShortUserName());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    namesys.renewDelegationToken(token);
                    Assert.fail((String)"Delegation token should not be renewed without Kerberos authentication");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

