/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSUpgradeFromImage;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.UO_Datanode1;
import org.apache.hadoop.hdfs.server.common.UO_Datanode2;
import org.apache.hadoop.hdfs.server.common.UO_Datanode3;
import org.apache.hadoop.hdfs.server.common.UO_Namenode1;
import org.apache.hadoop.hdfs.server.common.UO_Namenode2;
import org.apache.hadoop.hdfs.server.common.UO_Namenode3;
import org.apache.hadoop.hdfs.server.common.UpgradeObjectCollection;
import org.apache.hadoop.hdfs.server.common.Upgradeable;
import org.apache.hadoop.hdfs.tools.DFSAdmin;

public class TestDistributedUpgrade
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDistributedUpgrade.class);
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    void startNameNodeShouldFail(HdfsConstants.StartupOption operation) {
        try {
            this.cluster = new MiniDFSCluster(0, this.conf, 0, false, true, operation, null);
            throw new AssertionError((Object)"NameNode should have failed to start");
        }
        catch (Exception expected) {
            Object var2_3 = null;
            return;
        }
    }

    void startDataNodeShouldFail(HdfsConstants.StartupOption operation) {
        try {
            this.cluster.startDataNodes(this.conf, 1, false, operation, null);
            throw new AssertionError((Object)"DataNode should have failed to start");
        }
        catch (Exception expected) {
            TestDistributedUpgrade.assertFalse((boolean)this.cluster.isDataNodeUp());
            return;
        }
    }

    public void testDistributedUpgrade() throws Exception {
        int numDirs = 1;
        TestDFSUpgradeFromImage testImg = new TestDFSUpgradeFromImage();
        testImg.unpackStorage();
        int numDNs = testImg.numDataNodes;
        UpgradeObjectCollection.initialize();
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Datanode1());
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Namenode1());
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Datanode2());
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Namenode2());
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Datanode3());
        UpgradeObjectCollection.registerUpgrade((Upgradeable)new UO_Namenode3());
        this.conf = new Configuration();
        if (System.getProperty("test.build.data") == null) {
            System.setProperty("test.build.data", "build/test/data");
        }
        this.conf.setInt("dfs.datanode.scan.period.hours", -1);
        this.log("NameNode start in regular mode when dustributed upgrade is required", numDirs);
        this.startNameNodeShouldFail(HdfsConstants.StartupOption.REGULAR);
        this.log("Start NameNode only distributed upgrade", numDirs);
        this.cluster = new MiniDFSCluster(0, this.conf, 0, false, true, HdfsConstants.StartupOption.UPGRADE, null);
        this.cluster.shutdown();
        this.log("NameNode start in regular mode when dustributed upgrade has been started", numDirs);
        this.startNameNodeShouldFail(HdfsConstants.StartupOption.REGULAR);
        this.log("NameNode rollback to the old version that require a dustributed upgrade", numDirs);
        this.startNameNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
        this.log("Normal distributed upgrade for the cluster", numDirs);
        this.cluster = new MiniDFSCluster(0, this.conf, numDNs, false, true, HdfsConstants.StartupOption.UPGRADE, null);
        DFSAdmin dfsAdmin = new DFSAdmin();
        dfsAdmin.setConf(this.conf);
        dfsAdmin.run(new String[]{"-safemode", "wait"});
        this.cluster.shutdown();
        this.log("NameCluster regular startup after the upgrade", numDirs);
        this.cluster = new MiniDFSCluster(0, this.conf, numDNs, false, true, HdfsConstants.StartupOption.REGULAR, null);
        this.cluster.waitActive();
        this.cluster.shutdown();
    }

    public static void main(String[] args) throws Exception {
        new TestDistributedUpgrade().testDistributedUpgrade();
        LOG.info((Object)"=== DONE ===");
    }
}

