/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestDFSConcurrentFileOperations
extends TestCase {
    MiniDFSCluster cluster;
    FileSystem fs;
    private int writeSize;
    private long blockSize;

    protected void setUp() throws Exception {
        super.setUp();
        this.writeSize = 65536;
        this.blockSize = 2 * this.writeSize;
    }

    private void init() throws IOException {
        this.init(new Configuration());
    }

    private void init(Configuration conf) throws IOException {
        this.cluster = new MiniDFSCluster(conf, 3, true, new String[]{"/rack1", "/rack2", "/rack1"});
        this.cluster.waitClusterUp();
        this.fs = this.cluster.getFileSystem();
    }

    protected void tearDown() throws Exception {
        this.fs.close();
        this.cluster.shutdown();
        super.tearDown();
    }

    public void testLeaseRecoveryOnTrashedFile() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.size", this.blockSize);
        conf.setBoolean("dfs.support.broken.append", true);
        this.init(conf);
        String src = "/file-1";
        String dst = "/file-2";
        Path srcPath = new Path(src);
        Path dstPath = new Path(dst);
        FSDataOutputStream fos = this.fs.create(srcPath);
        AppendTestUtil.write((OutputStream)fos, 0, this.writeSize);
        fos.sync();
        this.fs.rename(srcPath, dstPath);
        try {
            fos.close();
            TestDFSConcurrentFileOperations.fail((String)"expected IOException");
        }
        catch (IOException e) {
            // empty catch block
        }
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(conf);
        AppendTestUtil.recoverFile(this.cluster, fs2, dstPath);
        AppendTestUtil.check(fs2, dstPath, this.writeSize);
    }
}

