/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestReplicationPolicyWithNodeGroup {
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 8;
    private static final int NUM_OF_DATANODES_BOUNDARY = 6;
    private static final int NUM_OF_DATANODES_MORE_TARGETS = 12;
    private static final Configuration CONF = new Configuration();
    private static final NetworkTopology cluster;
    private static final NameNode namenode;
    private static final BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private static final DatanodeDescriptor[] dataNodes;
    private static final DatanodeDescriptor[] dataNodesInBoundaryCase;
    private static final DatanodeDescriptor[] dataNodesInMoreTargetsCase;
    private static final DatanodeDescriptor NODE;

    private static void setupDataNodeCapacity() {
        for (int i = 0; i < 8; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
    }

    private static boolean checkTargetsOnDifferentNodeGroup(DatanodeDescriptor[] targets) {
        if (targets.length == 0) {
            return true;
        }
        HashSet<String> targetSet = new HashSet<String>();
        for (DatanodeDescriptor node : targets) {
            String nodeGroup = NetworkTopology.getLastHalf((String)node.getNetworkLocation());
            if (targetSet.contains(nodeGroup)) {
                return false;
            }
            targetSet.add(nodeGroup);
        }
        return true;
    }

    @Test
    public void testChooseTarget1() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 4);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)targets[1], (Node)targets[2]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    private void verifyNoTwoTargetsOnSameNodeGroup(DatanodeDescriptor[] targets) {
        HashSet<String> nodeGroupSet = new HashSet<String>();
        for (DatanodeDescriptor target : targets) {
            nodeGroupSet.add(target.getNetworkLocation());
        }
        Assert.assertEquals((long)nodeGroupSet.size(), (long)targets.length);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)replicator;
        ArrayList chosenNodes = new ArrayList();
        HashMap<DatanodeDescriptor, DatanodeDescriptor> excludedNodes = new HashMap<DatanodeDescriptor, DatanodeDescriptor>();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        DatanodeDescriptor[] targets = repl.chooseTarget(4, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertTrue((boolean)cluster.isNodeGroupAware());
        for (int i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)targets[0], (Node)targets[i]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
    }

    @Test
    public void testChooseTarget3() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 4096L, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertTrue((boolean)cluster.isNodeGroupAware());
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    @Test
    public void testChooseTarget4() throws Exception {
        for (int i = 0; i < 3; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 4096L, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[i], (Node)dataNodes[0]));
        }
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[0], (Node)targets[1]) || cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    @Test
    public void testChooseTarget5() throws Exception {
        TestReplicationPolicyWithNodeGroup.setupDataNodeCapacity();
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, NODE, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, NODE, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = replicator.chooseTarget(filename, 2, NODE, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, NODE, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
    }

    @Test
    public void testRereplicate1() throws Exception {
        TestReplicationPolicyWithNodeGroup.setupDataNodeCapacity();
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        TestReplicationPolicyWithNodeGroup.setupDataNodeCapacity();
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]) && cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[1]) ? 1 : 0) != 0);
    }

    @Test
    public void testRereplicate3() throws Exception {
        TestReplicationPolicyWithNodeGroup.setupDataNodeCapacity();
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[3]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 1, dataNodes[3], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[3], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[3], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)targets[0]));
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeDescriptor> replicaNodeList = new ArrayList<DatanodeDescriptor>();
        HashMap rackMap = new HashMap();
        dataNodes[0].setRemaining(0x400000L);
        replicaNodeList.add(dataNodes[0]);
        dataNodes[1].setRemaining(0x300000L);
        replicaNodeList.add(dataNodes[1]);
        dataNodes[2].setRemaining(0x200000L);
        replicaNodeList.add(dataNodes[2]);
        dataNodes[5].setRemaining(0x100000L);
        replicaNodeList.add(dataNodes[5]);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        replicator.splitNodesWithRack(replicaNodeList, rackMap, first, second);
        Assert.assertEquals((long)3L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        DatanodeDescriptor chosenNode = replicator.chooseReplicaToDelete(null, null, (short)3, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[1]);
        replicator.adjustSetsWithChosenReplica(rackMap, first, second, (DatanodeInfo)chosenNode);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        chosenNode = replicator.chooseReplicaToDelete(null, null, (short)2, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[2]);
        replicator.adjustSetsWithChosenReplica(rackMap, first, second, (DatanodeInfo)chosenNode);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        chosenNode = replicator.chooseReplicaToDelete(null, null, (short)1, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[5]);
    }

    @Test
    public void testChooseTargetsOnBoundaryTopology() throws Exception {
        int i;
        for (i = 0; i < 8; ++i) {
            cluster.remove((Node)dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            cluster.add((Node)dataNodesInBoundaryCase[i]);
        }
        for (i = 0; i < 6; ++i) {
            dataNodes[0].updateHeartbeat(10240L, 0L, 4096L, 0);
            dataNodesInBoundaryCase[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodesInBoundaryCase[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodesInBoundaryCase[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = replicator.chooseTarget(filename, 2, dataNodesInBoundaryCase[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodesInBoundaryCase[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testRereplicateOnBoundaryTopology() throws Exception {
        for (int i = 0; i < 6; ++i) {
            dataNodesInBoundaryCase[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodesInBoundaryCase[0]);
        chosenNodes.add(dataNodesInBoundaryCase[5]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 1, dataNodesInBoundaryCase[0], chosenNodes, 1024L);
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)targets[0], (Node)dataNodesInBoundaryCase[0]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)targets[0], (Node)dataNodesInBoundaryCase[5]));
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testChooseMoreTargetsThanNodeGroups() throws Exception {
        int i;
        for (i = 0; i < 6; ++i) {
            DatanodeDescriptor node = dataNodesInBoundaryCase[i];
            if (!cluster.contains((Node)node)) continue;
            cluster.remove((Node)node);
        }
        for (i = 0; i < 12; ++i) {
            cluster.add((Node)dataNodesInMoreTargetsCase[i]);
        }
        for (i = 0; i < 12; ++i) {
            dataNodesInMoreTargetsCase[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 3, dataNodesInMoreTargetsCase[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        targets = replicator.chooseTarget(filename, 10, dataNodesInMoreTargetsCase[0], new ArrayList(), 1024L);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        Assert.assertEquals((long)targets.length, (long)6L);
    }

    static {
        dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1/n1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1/n1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r1/n2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2/n3"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2/n3"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d1/r2/n4"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3/n5"), DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r3/n6")};
        dataNodesInBoundaryCase = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1/n1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1/n1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r1/n1"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r1/n2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2/n3"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d1/r2/n3")};
        dataNodesInMoreTargetsCase = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/r1/n1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/r1/n1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/r1/n2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/r1/n2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/r1/n3"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/r1/n3"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/r2/n4"), DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/r2/n4"), DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/r2/n5"), DFSTestUtil.getDatanodeDescriptor("10.10.10.10", "/r2/n5"), DFSTestUtil.getDatanodeDescriptor("11.11.11.11", "/r2/n6"), DFSTestUtil.getDatanodeDescriptor("12.12.12.12", "/r2/n6")};
        NODE = new DatanodeDescriptor((DatanodeID)DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/d2/r4/n7"));
        try {
            FileSystem.setDefaultUri((Configuration)CONF, (String)"hdfs://localhost:0");
            CONF.set("dfs.namenode.http-address", "0.0.0.0:0");
            CONF.set("dfs.block.replicator.classname", "org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyWithNodeGroup");
            CONF.set("net.topology.impl", "org.apache.hadoop.net.NetworkTopologyWithNodeGroup");
            File baseDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
            CONF.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
            NameNode.format((Configuration)CONF);
            namenode = new NameNode(CONF);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        FSNamesystem fsNamesystem = FSNamesystem.getFSNamesystem();
        replicator = fsNamesystem.replicator;
        cluster = fsNamesystem.clusterMap;
        for (int i = 0; i < 8; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        TestReplicationPolicyWithNodeGroup.setupDataNodeCapacity();
    }
}

