/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class TestSecurityTokenEditLog
extends TestCase {
    static final int NUM_DATA_NODES = 1;
    static final int NUM_TRANSACTIONS = 100;
    static final int NUM_THREADS = 100;
    static final int opsPerTrans = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditLog() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        try {
            int i;
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
            Iterator<File> it = cluster.getNameDirs().iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            FSEditLog.setBufferCapacity((int)2048);
            editLog.close();
            editLog.open();
            namesystem.getDelegationTokenSecretManager().startThreads();
            Thread[] threadId = new Thread[100];
            for (i = 0; i < 100; ++i) {
                Transactions trans = new Transactions(namesystem, 100);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            for (i = 0; i < 100; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
            editLog.close();
            namesystem.getDelegationTokenSecretManager().stopThreads();
            int numKeys = namesystem.getDelegationTokenSecretManager().getNumberOfKeys();
            Iterator it2 = fsimage.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.EDITS);
            while (it2.hasNext()) {
                File editFile = FSImage.getImageFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (FSImage.NameNodeFile)FSImage.NameNodeFile.EDITS);
                System.out.println("Verifying file: " + editFile);
                int numEdits = FSEditLog.loadFSEdits((EditLogInputStream)new FSEditLog.EditLogFileInputStream(editFile), (int)-1, null);
                TestSecurityTokenEditLog.assertTrue((String)("Verification for " + editFile + " failed. " + "Expected " + (30000 + numKeys) + " transactions. " + "Found " + numEdits + " transactions."), (numEdits == 30000 + numKeys ? 1 : 0) != 0);
            }
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static class Transactions
    implements Runnable {
        FSNamesystem namesystem;
        int numTransactions;
        short replication = (short)3;
        long blockSize = 64L;

        Transactions(FSNamesystem ns, int num) {
            this.namesystem = ns;
            this.numTransactions = num;
        }

        @Override
        public void run() {
            FSEditLog editLog = this.namesystem.getEditLog();
            for (int i = 0; i < this.numTransactions; ++i) {
                try {
                    String renewer = UserGroupInformation.getLoginUser().getUserName();
                    Token token = this.namesystem.getDelegationToken(new Text(renewer));
                    this.namesystem.renewDelegationToken(token);
                    this.namesystem.cancelDelegationToken(token);
                    editLog.logSync();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Transaction " + i + " encountered exception " + e);
                }
            }
        }
    }
}

