/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageDirectoryFailure {
    MiniDFSCluster cluster = null;
    FileSystem fs;
    SecondaryNameNode secondaryNN;
    ArrayList<String> nameDirs;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        String baseDir = System.getProperty("test.build.data", "/tmp");
        File dfsDir = new File(baseDir, "dfs");
        this.nameDirs = new ArrayList();
        this.nameDirs.add(new File(new File(dfsDir, "name1"), "nn").getPath());
        this.nameDirs.add(new File(new File(dfsDir, "name2"), "nn").getPath());
        this.nameDirs.add(new File(new File(dfsDir, "name3"), "nn").getPath());
        conf.set("dfs.name.dir", StringUtils.join(this.nameDirs, (String)","));
        conf.set("dfs.data.dir", new File(dfsDir, "data").getPath());
        conf.set("fs.checkpoint.dir", new File(dfsDir, "secondary").getPath());
        conf.set("fs.default.name", "hdfs://localhost:0");
        conf.set("dfs.http.address", "0.0.0.0:0");
        conf.set("dfs.secondary.http.address", "0.0.0.0:0");
        this.cluster = new MiniDFSCluster(0, conf, 1, true, false, true, null, null, null, null);
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.secondaryNN = new SecondaryNameNode(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.secondaryNN != null) {
            this.secondaryNN.shutdown();
        }
    }

    private List<Storage.StorageDirectory> getRemovedDirs() {
        return this.cluster.getNameNode().getFSImage().getRemovedStorageDirs();
    }

    private int numRemovedDirs() {
        return this.getRemovedDirs().size();
    }

    private void writeFile(String name, byte[] buff) throws IOException {
        FSDataOutputStream writeStream = this.fs.create(new Path(name));
        writeStream.write(buff, 0, buff.length);
        writeStream.close();
    }

    private byte[] readFile(String name, int len) throws IOException {
        FSDataInputStream readStream = this.fs.open(new Path(name));
        byte[] buff = new byte[len];
        readStream.readFully(buff);
        readStream.close();
        return buff;
    }

    private void checkFileCreation(String name) throws IOException {
        byte[] buff = "some bytes".getBytes();
        this.writeFile(name, buff);
        Assert.assertTrue((boolean)Arrays.equals(buff, this.readFile(name, buff.length)));
    }

    private void checkFileContents(String name) throws IOException {
        byte[] buff = "some bytes".getBytes();
        Assert.assertTrue((boolean)Arrays.equals(buff, this.readFile(name, buff.length)));
    }

    @Test
    public void testCheckpointAfterFailingFirstNamedir() throws IOException {
        Assert.assertEquals((long)0L, (long)this.numRemovedDirs());
        this.checkFileCreation("file0");
        FileUtil.fullyDelete((File)new File(this.nameDirs.get(0)));
        this.secondaryNN.doCheckpoint();
        Assert.assertEquals((long)1L, (long)this.numRemovedDirs());
        Assert.assertEquals((Object)this.nameDirs.get(0), (Object)this.getRemovedDirs().get(0).getRoot().getPath());
        this.checkFileCreation("file1");
        FileUtil.fullyDelete((File)new File(this.nameDirs.get(1)));
        this.secondaryNN.doCheckpoint();
        Assert.assertEquals((long)2L, (long)this.numRemovedDirs());
        Assert.assertEquals((Object)this.nameDirs.get(1), (Object)this.getRemovedDirs().get(1).getRoot().getPath());
        this.checkFileCreation("file2");
        FSEditLog spyLog = (FSEditLog)Mockito.spy((Object)this.cluster.getNameNode().getFSImage().getEditLog());
        ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).fatalExit(Mockito.anyString());
        this.cluster.getNameNode().getFSImage().setEditLog(spyLog);
        FileUtil.fullyDelete((File)new File(this.nameDirs.get(2)));
        try {
            this.secondaryNN.doCheckpoint();
            Assert.fail((String)"There's no storage to retrieve an image from");
        }
        catch (FileNotFoundException fnf) {
            // empty catch block
        }
        ((FSEditLog)Mockito.verify((Object)spyLog, (VerificationMode)Mockito.atLeastOnce())).fatalExit(Mockito.anyString());
        try {
            this.checkFileCreation("file3");
            Assert.fail((String)"Created a file w/o edit streams");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("java.lang.AssertionError: No edit streams to log to"));
        }
    }

    @Test
    public void testRestartAfterFailingStorageDir() throws IOException {
        Assert.assertEquals((long)0L, (long)this.numRemovedDirs());
        this.checkFileCreation("file0");
        FileUtil.fullyDelete((File)new File(this.nameDirs.get(0)));
        this.secondaryNN.doCheckpoint();
        Assert.assertEquals((long)1L, (long)this.numRemovedDirs());
        Assert.assertEquals((Object)this.nameDirs.get(0), (Object)this.getRemovedDirs().get(0).getRoot().getPath());
        this.checkFileCreation("file1");
        new File(this.nameDirs.get(0)).mkdir();
        this.cluster.restartNameNode();
        Assert.assertEquals((long)0L, (long)this.numRemovedDirs());
        this.checkFileContents("file0");
        this.checkFileContents("file1");
    }

    @Test
    public void testAbortOnNoValidEditDirs() throws IOException {
        this.cluster.restartNameNode();
        Assert.assertEquals((long)0L, (long)this.numRemovedDirs());
        this.checkFileCreation("file9");
        this.cluster.getNameNode().getFSImage().removeStorageDir(new File(this.nameDirs.get(0)));
        this.cluster.getNameNode().getFSImage().removeStorageDir(new File(this.nameDirs.get(1)));
        FSEditLog spyLog = (FSEditLog)Mockito.spy((Object)this.cluster.getNameNode().getFSImage().getEditLog());
        ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).fatalExit(Mockito.anyString());
        this.cluster.getNameNode().getFSImage().setEditLog(spyLog);
        this.cluster.getNameNode().getFSImage().removeStorageDir(new File(this.nameDirs.get(2)));
        ((FSEditLog)Mockito.verify((Object)spyLog, (VerificationMode)Mockito.atLeastOnce())).fatalExit(Mockito.anyString());
    }
}

