/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSMainOperationsBaseTest;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.web.resources.DatanodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFSMainOperationsWebHdfs
extends FSMainOperationsBaseTest {
    private static MiniDFSCluster cluster = null;
    private static Path defaultWorkingDirectory;

    public TestFSMainOperationsWebHdfs() {
        ((Log4JLogger)ExceptionHandler.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DatanodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void setupCluster() {
        final Configuration conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.setLong("dfs.block.size", 1024L);
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
            final String uri = "webhdfs://" + conf.get("dfs.http.address");
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
            fSys = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((URI)new URI(uri), (Configuration)conf);
                }
            });
            defaultWorkingDirectory = fSys.getWorkingDirectory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void shutdownCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Override
    protected Path getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    @Test
    public void testConcat() throws Exception {
        Path[] paths = new Path[]{new Path("/test/hadoop/file1"), new Path("/test/hadoop/file2"), new Path("/test/hadoop/file3")};
        DFSTestUtil.createFile(fSys, paths[0], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(fSys, paths[1], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(fSys, paths[2], 1024L, (short)3, 0L);
        Path catPath = new Path("/test/hadoop/catFile");
        DFSTestUtil.createFile(fSys, catPath, 1024L, (short)3, 0L);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, catPath));
        fSys.concat(catPath, paths);
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, paths[0]));
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, paths[1]));
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, paths[2]));
        FileStatus fileStatus = fSys.getFileStatus(catPath);
        Assert.assertEquals((long)4096L, (long)fileStatus.getLen());
    }

    @Override
    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
        Path testSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/subdir");
        try {
            fSys.mkdirs(testSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        Path testDeepSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/deep/sub/dir");
        try {
            fSys.mkdirs(testDeepSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDeepSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
    }
}

