/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.MiniMRCluster;

public class TestJobTrackerInstrumentation
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSlots() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.jobtracker.instrumentation", MyJobTrackerMetricsInst.class.getName());
            mr = new MiniMRCluster(2, "file:///", 3, null, null, jtConf);
            MyJobTrackerMetricsInst instr = (MyJobTrackerMetricsInst)mr.getJobTrackerRunner().getJobTracker().getInstrumentation();
            JobConf conf = mr.createJobConf();
            SleepJob job = new SleepJob();
            job.setConf((Configuration)conf);
            int numMapTasks = 3;
            int numReduceTasks = 2;
            job.run(numMapTasks, numReduceTasks, 10000L, 1, 10000L, 1);
            MyJobTrackerMetricsInst myJobTrackerMetricsInst = instr;
            synchronized (myJobTrackerMetricsInst) {
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrOccupiedMapSlots, (int)instr.decrOccupiedMapSlots);
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrOccupiedReduceSlots, (int)instr.decrOccupiedReduceSlots);
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrRunningMaps, (int)instr.decrRunningMaps);
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrRunningReduces, (int)instr.decrRunningReduces);
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrReservedMapSlots, (int)instr.decrReservedMapSlots);
                TestJobTrackerInstrumentation.assertEquals((int)instr.incrReservedReduceSlots, (int)instr.decrReservedReduceSlots);
                TestJobTrackerInstrumentation.assertTrue((instr.incrOccupiedMapSlots > 0 ? 1 : 0) != 0);
                TestJobTrackerInstrumentation.assertTrue((instr.incrOccupiedReduceSlots > 0 ? 1 : 0) != 0);
                TestJobTrackerInstrumentation.assertTrue((instr.incrRunningMaps > 0 ? 1 : 0) != 0);
                TestJobTrackerInstrumentation.assertTrue((instr.incrRunningReduces > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class MyJobTrackerMetricsInst
    extends JobTrackerInstrumentation {
        private int incrReservedMapSlots = 0;
        private int decrReservedMapSlots = 0;
        private int incrReservedReduceSlots = 0;
        private int decrReservedReduceSlots = 0;
        private int incrOccupiedMapSlots = 0;
        private int decrOccupiedMapSlots = 0;
        private int incrOccupiedReduceSlots = 0;
        private int decrOccupiedReduceSlots = 0;
        private int incrRunningMaps = 0;
        private int decrRunningMaps = 0;
        private int incrRunningReduces = 0;
        private int decrRunningReduces = 0;

        public MyJobTrackerMetricsInst(JobTracker tracker, JobConf conf) {
            super(tracker, conf);
        }

        public synchronized void addReservedMapSlots(int slots) {
            this.incrReservedMapSlots += slots;
        }

        public synchronized void decReservedMapSlots(int slots) {
            this.decrReservedMapSlots += slots;
        }

        public synchronized void addReservedReduceSlots(int slots) {
            this.incrReservedReduceSlots += slots;
        }

        public synchronized void decReservedReduceSlots(int slots) {
            this.decrReservedReduceSlots += slots;
        }

        public synchronized void addOccupiedMapSlots(int slots) {
            this.incrOccupiedMapSlots += slots;
        }

        public synchronized void decOccupiedMapSlots(int slots) {
            this.decrOccupiedMapSlots += slots;
        }

        public synchronized void addOccupiedReduceSlots(int slots) {
            this.incrOccupiedReduceSlots += slots;
        }

        public synchronized void decOccupiedReduceSlots(int slots) {
            this.decrOccupiedReduceSlots += slots;
        }

        public synchronized void addRunningMaps(int task) {
            this.incrRunningMaps += task;
        }

        public synchronized void decRunningMaps(int task) {
            this.decrRunningMaps += task;
        }

        public synchronized void addRunningReduces(int task) {
            this.incrRunningReduces += task;
        }

        public synchronized void decRunningReduces(int task) {
            this.decrRunningReduces += task;
        }
    }
}

